/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.jurassicraft.common.world;

import cpw.mods.fml.common.IWorldGenerator;
import java.util.Random;
import net.ilexiconn.jurassicraft.common.block.JCBlockRegistry;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;

public class WorldGenFossilOre
implements IWorldGenerator {
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        if (world.field_73011_w.func_76569_d()) {
            for (int i = 0; i < 20; ++i) {
                int z;
                int x = random.nextInt(16) + chunkX * 16;
                int worldHeight = world.func_72976_f(x, z = random.nextInt(16) + chunkZ * 16);
                if (worldHeight <= 0) {
                    worldHeight = 4;
                }
                int y = random.nextInt(worldHeight);
                this.generateOre(world, random, x, y, z);
            }
        }
    }

    public boolean generateOre(World world, Random random, int x, int y, int z) {
        int numberOfBlocks = 7 + random.nextInt(3);
        float f = random.nextFloat() * (float)Math.PI;
        double d0 = (float)(x + 8) + MathHelper.func_76126_a((float)f) * (float)numberOfBlocks / 8.0f;
        double d1 = (float)(x + 8) - MathHelper.func_76126_a((float)f) * (float)numberOfBlocks / 8.0f;
        double d2 = (float)(z + 8) + MathHelper.func_76134_b((float)f) * (float)numberOfBlocks / 8.0f;
        double d3 = (float)(z + 8) - MathHelper.func_76134_b((float)f) * (float)numberOfBlocks / 8.0f;
        double d4 = y + random.nextInt(3) - 2;
        double d5 = y + random.nextInt(3) - 2;
        for (int l = 0; l <= numberOfBlocks; ++l) {
            double d6 = d0 + (d1 - d0) * (double)l / (double)numberOfBlocks;
            double d7 = d4 + (d5 - d4) * (double)l / (double)numberOfBlocks;
            double d8 = d2 + (d3 - d2) * (double)l / (double)numberOfBlocks;
            double d9 = random.nextDouble() * (double)numberOfBlocks / 16.0;
            double d10 = (double)(MathHelper.func_76126_a((float)((float)l * (float)Math.PI / (float)numberOfBlocks)) + 1.0f) * d9 + 1.0;
            double d11 = (double)(MathHelper.func_76126_a((float)((float)l * (float)Math.PI / (float)numberOfBlocks)) + 1.0f) * d9 + 1.0;
            int i1 = MathHelper.func_76128_c((double)(d6 - d10 / 2.0));
            int j1 = MathHelper.func_76128_c((double)(d7 - d11 / 2.0));
            int k1 = MathHelper.func_76128_c((double)(d8 - d10 / 2.0));
            int l1 = MathHelper.func_76128_c((double)(d6 + d10 / 2.0));
            int i2 = MathHelper.func_76128_c((double)(d7 + d11 / 2.0));
            int j2 = MathHelper.func_76128_c((double)(d8 + d10 / 2.0));
            for (int k2 = i1; k2 <= l1; ++k2) {
                double d12 = ((double)k2 + 0.5 - d6) / (d10 / 2.0);
                if (!(d12 * d12 < 1.0)) continue;
                for (int l2 = j1; l2 <= i2; ++l2) {
                    double d13 = ((double)l2 + 0.5 - d7) / (d11 / 2.0);
                    if (!(d12 * d12 + d13 * d13 < 1.0)) continue;
                    for (int i3 = k1; i3 <= j2; ++i3) {
                        double d14 = ((double)i3 + 0.5 - d8) / (d10 / 2.0);
                        Block block = world.func_147439_a(k2, l2, i3);
                        int blockMetadata = world.func_72805_g(k2, l2, i3);
                        if (!block.isReplaceableOreGen(world, k2, l2, i3, Blocks.field_150348_b) && !block.isReplaceableOreGen(world, k2, l2, i3, Blocks.field_150322_A) && !block.isReplaceableOreGen(world, k2, l2, i3, Blocks.field_150405_ch) && !block.isReplaceableOreGen(world, k2, l2, i3, Blocks.field_150406_ce) || !(d12 * d12 + d13 * d13 + d14 * d14 < 1.0)) continue;
                        Block toGenerate = JCBlockRegistry.fossilOre;
                        int metadataToGenerate = random.nextInt(6);
                        if (block == Blocks.field_150405_ch) {
                            toGenerate = JCBlockRegistry.clayFossilOre;
                            metadataToGenerate = 0;
                        } else if (block == Blocks.field_150406_ce) {
                            toGenerate = JCBlockRegistry.clayFossilOre;
                            metadataToGenerate = this.convertVanillaMetadataToOre(blockMetadata);
                        } else if (block == Blocks.field_150322_A || block == Blocks.field_150354_m) {
                            toGenerate = JCBlockRegistry.sandstoneFossilOre;
                            metadataToGenerate = random.nextInt(6);
                        }
                        world.func_147465_d(k2, l2, i3, toGenerate, metadataToGenerate, 2);
                    }
                }
            }
        }
        return true;
    }

    private int convertVanillaMetadataToOre(int metadata) {
        switch (metadata) {
            case 0: {
                return 5;
            }
            case 1: {
                return 2;
            }
            case 4: {
                return 6;
            }
            case 8: {
                return 4;
            }
            case 12: {
                return 1;
            }
            case 14: {
                return 3;
            }
        }
        return 0;
    }
}

