/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.llibrary.client.gui.config;

import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.ilexiconn.llibrary.LLibrary;
import net.ilexiconn.llibrary.client.gui.ElementGUI;
import net.ilexiconn.llibrary.client.gui.config.ConfigCategory;
import net.ilexiconn.llibrary.client.gui.config.ConfigProperty;
import net.ilexiconn.llibrary.client.gui.element.ButtonElement;
import net.ilexiconn.llibrary.client.gui.element.CheckboxElement;
import net.ilexiconn.llibrary.client.gui.element.ColorElement;
import net.ilexiconn.llibrary.client.gui.element.Element;
import net.ilexiconn.llibrary.client.gui.element.ElementHandler;
import net.ilexiconn.llibrary.client.gui.element.InputElement;
import net.ilexiconn.llibrary.client.gui.element.LabelElement;
import net.ilexiconn.llibrary.client.gui.element.ListElement;
import net.ilexiconn.llibrary.client.gui.element.SliderElement;
import net.ilexiconn.llibrary.client.gui.element.color.ColorScheme;
import net.ilexiconn.llibrary.server.util.IValueAccess;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class ConfigGUI
extends ElementGUI {
    public static final ColorScheme RETURN = ColorScheme.create(() -> LLibrary.CONFIG.getPrimaryColor(), () -> LLibrary.CONFIG.getSecondaryColor());
    public static final ColorScheme SIDEBAR = ColorScheme.create(() -> LLibrary.CONFIG.getPrimaryColor(), () -> LLibrary.CONFIG.getTertiaryColor());
    public static final ResourceLocation SETTINGS_ICON = new ResourceLocation("llibrary", "textures/gui/settings.png");
    protected GuiScreen parent;
    protected List<ConfigCategory> categories = new ArrayList<ConfigCategory>();
    protected Map<ConfigProperty<?>, Element<ConfigGUI>> propertyElements = new HashMap();
    protected ConfigCategory selectedCategory;
    private Mod mod;

    public ConfigGUI(GuiScreen parent, Object mod, Configuration config) {
        this.parent = parent;
        if (!mod.getClass().isAnnotationPresent(Mod.class)) {
            throw new RuntimeException("@Mod annotation not found in class " + mod + "!");
        }
        this.mod = mod.getClass().getAnnotation(Mod.class);
        if (config != null) {
            this.categories.addAll(config.getCategoryNames().stream().map(name -> {
                LinkedHashMap propertyMap = new LinkedHashMap();
                final net.minecraftforge.common.config.ConfigCategory configCategory = config.getCategory(name);
                for (final Map.Entry entry : configCategory.entrySet()) {
                    ConfigProperty configProperty = new ConfigProperty(new IValueAccess(){

                        @Override
                        public void accept(Object string) {
                            configCategory.put((String)entry.getKey(), new Property((String)entry.getKey(), String.valueOf(string), null));
                        }

                        @Override
                        public Object get() {
                            return configCategory.get((String)entry.getKey()).getString();
                        }
                    }, ((Property)entry.getValue()).getType());
                    propertyMap.put((String)entry.getKey(), configProperty);
                }
                return new ConfigCategory((String)name, propertyMap);
            }).collect(Collectors.toList()));
        }
    }

    @Override
    public void initElements() {
        this.elementList.add(new ButtonElement<ConfigGUI>(this, "<", 0.0f, 0.0f, 30, 20, button -> {
            this.field_146297_k.func_147108_a(this.parent);
            return true;
        }).withColorScheme(RETURN));
        this.elementList.add(new LabelElement<ConfigGUI>(this, "Mod List", 35.0f, 6.0f));
        this.elementList.add(new LabelElement<ConfigGUI>(this, this.mod.name().toUpperCase() + " SETTINGS", 35.0f, 26.0f));
        ListElement categoryList = (ListElement)new ListElement<ConfigGUI>(this, 0.0f, 40.0f, 120, this.field_146295_m - 40, this.categories.stream().map(ConfigCategory::getName).collect(Collectors.toList()), 20, list -> {
            this.selectedCategory = this.categories.get(list.getSelectedIndex());
            for (Map.Entry<ConfigProperty<?>, Element<ConfigGUI>> element : this.propertyElements.entrySet()) {
                ElementHandler.INSTANCE.removeElement(this, element.getValue());
            }
            this.propertyElements.clear();
            return true;
        }).withPersistence(true).withColorScheme(SIDEBAR);
        categoryList.setSelectedIndex(0);
        this.selectedCategory = this.categories.get(0);
        this.elementList.add(categoryList);
        this.propertyElements.clear();
    }

    @Override
    public void drawScreen(float mouseX, float mouseY, float partialTicks) {
        Gui.func_73734_a((int)0, (int)0, (int)this.field_146294_l, (int)40, (int)LLibrary.CONFIG.getPrimaryColor());
        Gui.func_73734_a((int)120, (int)40, (int)this.field_146294_l, (int)this.field_146295_m, (int)LLibrary.CONFIG.getInvertedTextColor());
        GL11.glPushMatrix();
        GL11.glEnable((int)3042);
        int color = LLibrary.CONFIG.getAccentColor();
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        GL11.glColor4f((float)r, (float)g, (float)b, (float)a);
        GL11.glScalef((float)0.15f, (float)0.15f, (float)0.15f);
        this.field_146297_k.func_110434_K().func_110577_a(SETTINGS_ICON);
        this.func_73729_b(40, 135, 0, 0, 128, 128);
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
        int x = 125;
        int y = 45;
        for (Map.Entry<String, ConfigProperty<?>> propertyEntry : this.selectedCategory.getProperties().entrySet()) {
            String name = propertyEntry.getKey();
            ConfigProperty<?> property = propertyEntry.getValue();
            this.field_146289_q.func_78276_b(name, x, y, LLibrary.CONFIG.getTextColor());
            Element<ConfigGUI> propertyElement = this.propertyElements.get(property);
            if (propertyElement == null) {
                propertyElement = this.createPropertyElement(property, x, y + 10);
                this.propertyElements.put(property, propertyElement);
                if (propertyElement != null) {
                    this.elementList.add(propertyElement);
                    ElementHandler.INSTANCE.addElement(this, propertyElement);
                }
            }
            if (propertyElement == null) continue;
            y += propertyElement.getHeight() + 14;
        }
    }

    private Element<ConfigGUI> createPropertyElement(ConfigProperty property, int x, int y) {
        switch (property.getType()) {
            case BOOLEAN: {
                return new CheckboxElement<ConfigGUI>(this, x, y, checkbox -> {
                    property.set(checkbox.isSelected());
                    return true;
                }).withSelection(property.get() instanceof Boolean ? (Boolean)property.get() : Boolean.parseBoolean((String)property.get()));
            }
            case COLOR: {
                return new ColorElement<ConfigGUI>(this, x, y, 195, 149, color -> {
                    property.set(color.getColor());
                    return true;
                });
            }
            case STRING: {
                return new InputElement<ConfigGUI>(this, (String)property.get(), x, y, 192, input -> property.set(input.getText()));
            }
            case DOUBLE: {
                return new SliderElement<ConfigGUI>(this, (float)x, (float)y, false, slider -> {
                    property.set(slider.doubleValue());
                    return true;
                }).withValue(Float.valueOf(String.valueOf(property.get())).floatValue());
            }
            case INTEGER: {
                return new SliderElement<ConfigGUI>(this, (float)x, (float)y, true, slider -> {
                    property.set(slider.intValue());
                    return true;
                }).withValue(Integer.valueOf(String.valueOf(property.get())).intValue());
            }
        }
        return null;
    }

    @Override
    public void func_146281_b() {
        MinecraftForge.EVENT_BUS.post((Event)new ConfigChangedEvent.OnConfigChangedEvent(this.mod.modid(), null, this.field_146297_k.field_71441_e != null, false));
        super.func_146281_b();
    }
}

