/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.llibrary.client.gui.update;

import cpw.mods.fml.client.GuiScrollingList;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import net.ilexiconn.llibrary.client.ClientProxy;
import net.ilexiconn.llibrary.client.gui.update.ModUpdateGUI;
import net.ilexiconn.llibrary.server.update.UpdateContainer;
import net.ilexiconn.llibrary.server.update.UpdateHandler;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Vector2f;

@SideOnly(value=Side.CLIENT)
public class ModUpdateListGUI
extends GuiScrollingList {
    private ModUpdateGUI parent;
    private Map<Integer, ResourceLocation> cachedLogo;
    private Map<Integer, Vector2f> cachedLogoDimensions;

    public ModUpdateListGUI(ModUpdateGUI parent, int width) {
        super(parent.field_146297_k, width, parent.field_146295_m, 32, parent.field_146295_m - 55, 10, 35);
        this.parent = parent;
        this.cachedLogo = new HashMap<Integer, ResourceLocation>();
        this.cachedLogoDimensions = new HashMap<Integer, Vector2f>();
    }

    protected int getSize() {
        return UpdateHandler.INSTANCE.getOutdatedModList().size();
    }

    protected void elementClicked(int index, boolean doubleClick) {
        this.parent.selectModIndex(index);
    }

    protected boolean isSelected(int index) {
        return this.parent.modIndexSelected(index);
    }

    protected void drawBackground() {
        this.parent.func_146276_q_();
    }

    protected int getContentHeight() {
        return this.getSize() * 35 + 1;
    }

    protected void drawSlot(int idx, int right, int top, int height, Tessellator tess) {
        BufferedImage icon;
        UpdateContainer updateContainer = UpdateHandler.INSTANCE.getOutdatedModList().get(idx);
        String name = StringUtils.func_76338_a((String)updateContainer.getModContainer().getName());
        String version = StringUtils.func_76338_a((String)updateContainer.getLatestVersion().getVersionString());
        FontRenderer font = ClientProxy.MINECRAFT.field_71466_p;
        if (!this.cachedLogo.containsKey(idx) && (icon = updateContainer.getIcon()) != null) {
            this.cachedLogo.put(idx, ClientProxy.MINECRAFT.func_110434_K().func_110578_a("mod_icon", new DynamicTexture(icon)));
            this.cachedLogoDimensions.put(idx, new Vector2f((float)icon.getWidth(), (float)icon.getHeight()));
        }
        boolean hasIcon = this.cachedLogo.containsKey(idx);
        font.func_78276_b(font.func_78269_a(name, this.listWidth - 10), hasIcon ? this.left + 36 : this.left + 6, top + 7, 0xFFFFFF);
        font.func_78276_b(font.func_78269_a(version, this.listWidth - 10), hasIcon ? this.left + 36 : this.left + 6, top + 17, 0xCCCCCC);
        if (hasIcon) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            ClientProxy.MINECRAFT.field_71446_o.func_110577_a(this.cachedLogo.get(idx));
            float scaleX = this.cachedLogoDimensions.get(idx).getX() / 32.0f;
            float scaleY = this.cachedLogoDimensions.get(idx).getY() / 32.0f;
            float scale = 1.0f;
            if (scaleX > 1.0f || scaleY > 1.0f) {
                scale = 1.0f / Math.max(scaleX, scaleY);
            }
            float iconWidth = this.cachedLogoDimensions.get(idx).getX() * scale;
            float iconHeight = this.cachedLogoDimensions.get(idx).getY() * scale;
            int offset = 12;
            tess.func_78382_b();
            tess.func_78374_a((double)offset, (double)((float)top + iconHeight), 0.0, 0.0, 1.0);
            tess.func_78374_a((double)((float)offset + iconWidth), (double)((float)top + iconHeight), 0.0, 1.0, 1.0);
            tess.func_78374_a((double)((float)offset + iconWidth), (double)top, 0.0, 1.0, 0.0);
            tess.func_78374_a((double)offset, (double)top, 0.0, 0.0, 0.0);
            tess.func_78381_a();
        }
    }

    public int getWidth() {
        return this.listWidth;
    }
}

