/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.llibrary.server.asm;

import cpw.mods.fml.relauncher.IFMLLoadingPlugin;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.ilexiconn.llibrary.server.asm.transformer.ITransformer;
import net.ilexiconn.llibrary.server.asm.transformer.LocaleTransformer;
import net.ilexiconn.llibrary.server.asm.transformer.ModContainerTransformer;
import net.ilexiconn.llibrary.server.asm.transformer.ModelBipedTransformer;
import net.ilexiconn.llibrary.server.asm.transformer.RenderPlayerTransformer;
import net.ilexiconn.llibrary.server.asm.transformer.ServerTransformer;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;

@IFMLLoadingPlugin.Name(value="llibrary")
@IFMLLoadingPlugin.MCVersion(value="1.7.10")
@IFMLLoadingPlugin.SortingIndex(value=1001)
@IFMLLoadingPlugin.TransformerExclusions(value={"net.ilexiconn.llibrary.server.asm."})
public class LLibraryPlugin
implements IFMLLoadingPlugin,
IClassTransformer {
    private List<ITransformer> transformerList = new ArrayList<ITransformer>();

    public LLibraryPlugin() {
        this.transformerList.add(new ServerTransformer());
        this.transformerList.add(new LocaleTransformer());
        this.transformerList.add(new RenderPlayerTransformer());
        this.transformerList.add(new ModelBipedTransformer());
        this.transformerList.add(new ModContainerTransformer());
    }

    public String[] getASMTransformerClass() {
        return new String[]{this.getClass().getName()};
    }

    public String getModContainerClass() {
        return null;
    }

    public String getSetupClass() {
        return null;
    }

    public void injectData(Map<String, Object> data) {
    }

    public String getAccessTransformerClass() {
        return null;
    }

    public byte[] transform(String name, String transformedName, byte[] bytes) {
        for (ITransformer transformer : this.transformerList) {
            if (!transformer.getTarget().equals(transformedName)) continue;
            ClassReader classReader = new ClassReader(bytes);
            ClassNode classNode = new ClassNode();
            classReader.accept((ClassVisitor)classNode, 0);
            transformer.transform(classNode, transformedName.equals(name));
            ClassWriter classWriter = new ClassWriter(classReader, 1);
            classNode.accept((ClassVisitor)classWriter);
            this.saveBytecode(transformedName, classWriter);
            bytes = classWriter.toByteArray();
        }
        return bytes;
    }

    private void saveBytecode(String name, ClassWriter classWriter) {
        try {
            File debugDir = new File("llibrary/debug/");
            if (debugDir.exists()) {
                debugDir.delete();
            }
            debugDir.mkdirs();
            FileOutputStream out = new FileOutputStream(new File(debugDir, name + ".class"));
            out.write(classWriter.toByteArray());
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

