/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.client.render.entity;

import com.google.common.collect.Maps;
import java.util.Map;
import net.ilexiconn.llibrary.client.model.tabula.ITabulaModelAnimator;
import net.ilexiconn.llibrary.client.model.tabula.TabulaModel;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jurassicraft.JurassiCraft;
import org.jurassicraft.client.model.animation.entity.vehicle.HelicopterAnimator;
import org.jurassicraft.server.entity.vehicle.HelicopterBaseEntity;
import org.jurassicraft.server.entity.vehicle.modules.HelicopterModule;
import org.jurassicraft.server.entity.vehicle.modules.HelicopterModuleSpot;
import org.jurassicraft.server.tabula.TabulaModelHelper;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class HelicopterRenderer
implements IRenderFactory<HelicopterBaseEntity> {
    public Render<? super HelicopterBaseEntity> createRenderFor(RenderManager manager) {
        return new Renderer(manager);
    }

    public static class Renderer
    extends Render<HelicopterBaseEntity> {
        private static final ResourceLocation TEXTURE = new ResourceLocation("jurassicraft", "textures/entities/helicopter/ranger_helicopter_texture.png");
        private final Map<String, TabulaModel> moduleMap = Maps.newHashMap();
        private final Map<String, ResourceLocation> moduleTextures = Maps.newHashMap();
        private TabulaModel baseModel;

        public Renderer(RenderManager manager) {
            super(manager);
            try {
                this.baseModel = new TabulaModel(TabulaModelHelper.loadTabulaModel("/assets/jurassicraft/models/entities/helicopter/ranger_helicopter"), (ITabulaModelAnimator)new HelicopterAnimator());
                for (String id : HelicopterModule.registry.keySet()) {
                    TabulaModel model = new TabulaModel(TabulaModelHelper.loadTabulaModel("/assets/jurassicraft/models/entities/helicopter/modules/ranger_helicopter_" + id));
                    this.moduleMap.put(id, model);
                    this.moduleTextures.put(id, new ResourceLocation("jurassicraft", "textures/entities/helicopter/modules/ranger_helicopter_" + id + "_texture.png"));
                }
            }
            catch (Exception e) {
                JurassiCraft.INSTANCE.getLogger().fatal("Failed to load the models for the Helicopter", (Throwable)e);
            }
        }

        public void doRender(HelicopterBaseEntity helicopter, double x, double y, double z, float yaw, float partialTicks) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)((float)x), (float)((float)y + 1.5f), (float)((float)z));
            GlStateManager.func_179114_b((float)(180.0f - yaw), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)helicopter.field_70125_A, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)helicopter.getRoll(), (float)0.0f, (float)0.0f, (float)1.0f);
            float f4 = 1.0f;
            GlStateManager.func_179152_a((float)f4, (float)f4, (float)f4);
            GlStateManager.func_179152_a((float)(1.0f / f4), (float)(1.0f / f4), (float)(1.0f / f4));
            this.func_180548_c((Entity)helicopter);
            GlStateManager.func_179152_a((float)-1.0f, (float)-1.0f, (float)1.0f);
            GL11.glEnable((int)3042);
            GL11.glDisable((int)3008);
            GL11.glBlendFunc((int)770, (int)771);
            this.baseModel.func_78088_a((Entity)helicopter, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
            this.renderModules(helicopter);
            GL11.glDisable((int)3042);
            GL11.glEnable((int)3008);
            GlStateManager.func_179121_F();
            super.func_76986_a((Entity)helicopter, x, y, z, yaw, partialTicks);
        }

        private void renderModules(HelicopterBaseEntity helicopter) {
            for (HelicopterModuleSpot spot : helicopter.getModuleSpots()) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179114_b((float)((float)Math.toDegrees(spot.getAngleFromCenter())), (float)0.0f, (float)1.0f, (float)0.0f);
                for (HelicopterModule m : spot.getModules()) {
                    if (m == null) continue;
                    GlStateManager.func_179114_b((float)((float)Math.toDegrees(m.getBaseRotationAngle())), (float)0.0f, (float)1.0f, (float)0.0f);
                    this.func_110776_a(this.moduleTextures.get(m.getModuleID()));
                    TabulaModel model = this.moduleMap.get(m.getModuleID());
                    model.func_78088_a((Entity)helicopter, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
                    GlStateManager.func_179114_b((float)(-((float)Math.toDegrees(m.getBaseRotationAngle()))), (float)0.0f, (float)1.0f, (float)0.0f);
                }
                GlStateManager.func_179121_F();
            }
        }

        protected ResourceLocation getEntityTexture(HelicopterBaseEntity entity) {
            return TEXTURE;
        }
    }
}

