/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.client.render.entity;

import net.ilexiconn.llibrary.client.model.tabula.ITabulaModelAnimator;
import net.ilexiconn.llibrary.client.model.tabula.TabulaModel;
import net.ilexiconn.llibrary.client.model.tabula.container.TabulaModelContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jurassicraft.JurassiCraft;
import org.jurassicraft.client.model.ResetControlTabulaModel;
import org.jurassicraft.client.model.animation.entity.vehicle.JeepWranglerAnimator;
import org.jurassicraft.server.entity.vehicle.JeepWranglerEntity;
import org.jurassicraft.server.tabula.TabulaModelHelper;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class JeepWranglerRenderer
implements IRenderFactory<JeepWranglerEntity> {
    public Render<? super JeepWranglerEntity> createRenderFor(RenderManager manager) {
        return new Renderer(manager);
    }

    public static class Renderer
    extends Render<JeepWranglerEntity> {
        private static final ResourceLocation TEXTURE = new ResourceLocation("jurassicraft", "textures/entities/jeep_wrangler/jeep_wrangler.png");
        protected static final ResourceLocation[] DESTROY_STAGES = new ResourceLocation[]{new ResourceLocation("textures/blocks/destroy_stage_0.png"), new ResourceLocation("textures/blocks/destroy_stage_1.png"), new ResourceLocation("textures/blocks/destroy_stage_2.png"), new ResourceLocation("textures/blocks/destroy_stage_3.png"), new ResourceLocation("textures/blocks/destroy_stage_4.png"), new ResourceLocation("textures/blocks/destroy_stage_5.png"), new ResourceLocation("textures/blocks/destroy_stage_6.png"), new ResourceLocation("textures/blocks/destroy_stage_7.png"), new ResourceLocation("textures/blocks/destroy_stage_8.png"), new ResourceLocation("textures/blocks/destroy_stage_9.png")};
        private TabulaModel baseModel;
        private TabulaModel destroyModel;

        public Renderer(RenderManager manager) {
            super(manager);
            try {
                JeepWranglerAnimator animator = new JeepWranglerAnimator();
                TabulaModelContainer container = TabulaModelHelper.loadTabulaModel("/assets/jurassicraft/models/entities/jeep_wrangler/jeep_wrangler.tbl");
                this.baseModel = new ResetControlTabulaModel(container, animator);
                this.destroyModel = new TabulaModel(TabulaModelHelper.loadTabulaModel("/assets/jurassicraft/models/entities/jeep_wrangler/jeep_wrangler_break.tbl"), (ITabulaModelAnimator)animator);
            }
            catch (Exception e) {
                JurassiCraft.INSTANCE.getLogger().fatal("Failed to load the models for the Jeep Wrangler", (Throwable)e);
            }
        }

        public void doRender(JeepWranglerEntity entity, double x, double y, double z, float yaw, float partialTicks) {
            GlStateManager.func_179147_l();
            GL11.glBlendFunc((int)770, (int)771);
            this.func_180548_c(entity);
            this.renderModel(entity, x, y, z, yaw, false);
            int destroyStage = Math.min(10, (int)(10.0f - entity.health / 40.0f * 10.0f)) - 1;
            if (destroyStage >= 0) {
                GlStateManager.func_179131_c((float)0.4f, (float)0.4f, (float)0.4f, (float)((float)destroyStage / 10.0f / 2.0f + 0.1f));
                this.func_110776_a(DESTROY_STAGES[destroyStage]);
                this.renderModel(entity, x, y, z, yaw, true);
            }
            GlStateManager.func_179084_k();
            super.func_76986_a((Entity)entity, x, y, z, yaw, partialTicks);
        }

        private void renderModel(JeepWranglerEntity entity, double x, double y, double z, float yaw, boolean destroy) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)((float)x), (float)((float)y + 1.25f), (float)((float)z));
            GlStateManager.func_179114_b((float)(180.0f - yaw), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179152_a((float)-1.0f, (float)-1.0f, (float)1.0f);
            (destroy ? this.destroyModel : this.baseModel).func_78088_a((Entity)entity, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
            GlStateManager.func_179121_F();
        }

        protected ResourceLocation getEntityTexture(JeepWranglerEntity entity) {
            return TEXTURE;
        }
    }
}

