/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.block;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.oredict.OreDictionary;
import org.jurassicraft.server.api.SubBlocksBlock;
import org.jurassicraft.server.block.ActionFigureBlock;
import org.jurassicraft.server.block.AmberBlock;
import org.jurassicraft.server.block.BasicBlock;
import org.jurassicraft.server.block.ClearGlassBlock;
import org.jurassicraft.server.block.EncasedFossilBlock;
import org.jurassicraft.server.block.FossilBlock;
import org.jurassicraft.server.block.FossilizedTrackwayBlock;
import org.jurassicraft.server.block.GypsumStoneBlock;
import org.jurassicraft.server.block.NestFossilBlock;
import org.jurassicraft.server.block.PaleoBaleBlock;
import org.jurassicraft.server.block.PeatBlock;
import org.jurassicraft.server.block.PeatMossBlock;
import org.jurassicraft.server.block.PlantFossilBlock;
import org.jurassicraft.server.block.entity.ActionFigureBlockEntity;
import org.jurassicraft.server.block.entity.CleaningStationBlockEntity;
import org.jurassicraft.server.block.entity.DNACombinatorHybridizerBlockEntity;
import org.jurassicraft.server.block.entity.DNAExtractorBlockEntity;
import org.jurassicraft.server.block.entity.DNASequencerBlockEntity;
import org.jurassicraft.server.block.entity.DNASynthesizerBlockEntity;
import org.jurassicraft.server.block.entity.EmbryoCalcificationMachineBlockEntity;
import org.jurassicraft.server.block.entity.EmbryonicMachineBlockEntity;
import org.jurassicraft.server.block.entity.FeederBlockEntity;
import org.jurassicraft.server.block.entity.FossilGrinderBlockEntity;
import org.jurassicraft.server.block.entity.IncubatorBlockEntity;
import org.jurassicraft.server.block.machine.CleaningStationBlock;
import org.jurassicraft.server.block.machine.CultivatorBottomBlock;
import org.jurassicraft.server.block.machine.CultivatorTopBlock;
import org.jurassicraft.server.block.machine.DNACombinatorHybridizerBlock;
import org.jurassicraft.server.block.machine.DNAExtractorBlock;
import org.jurassicraft.server.block.machine.DNASequencerBlock;
import org.jurassicraft.server.block.machine.DNASynthesizerBlock;
import org.jurassicraft.server.block.machine.EmbryoCalcificationMachineBlock;
import org.jurassicraft.server.block.machine.EmbryonicMachineBlock;
import org.jurassicraft.server.block.machine.FeederBlock;
import org.jurassicraft.server.block.machine.FossilGrinderBlock;
import org.jurassicraft.server.block.machine.IncubatorBlock;
import org.jurassicraft.server.block.plant.AjuginuculaSmithiiBlock;
import org.jurassicraft.server.block.plant.AncientPlantBlock;
import org.jurassicraft.server.block.plant.BennettitaleanCycadeoideaBlock;
import org.jurassicraft.server.block.plant.CycadZamitesBlock;
import org.jurassicraft.server.block.plant.DicksoniaBlock;
import org.jurassicraft.server.block.plant.DicroidiumZuberiBlock;
import org.jurassicraft.server.block.plant.DictyophyllumBlock;
import org.jurassicraft.server.block.plant.EncephalartosBlock;
import org.jurassicraft.server.block.plant.GracilariaBlock;
import org.jurassicraft.server.block.plant.LadiniaSimplexBlock;
import org.jurassicraft.server.block.plant.LiriodendritesBlock;
import org.jurassicraft.server.block.plant.MossBlock;
import org.jurassicraft.server.block.plant.OrontiumMackiiBlock;
import org.jurassicraft.server.block.plant.RaphaeliaBlock;
import org.jurassicraft.server.block.plant.ScalyTreeFernBlock;
import org.jurassicraft.server.block.plant.SerennaVeriformansBlock;
import org.jurassicraft.server.block.plant.SmallChainFernBlock;
import org.jurassicraft.server.block.plant.SmallCycadBlock;
import org.jurassicraft.server.block.plant.SmallRoyalFernBlock;
import org.jurassicraft.server.block.plant.UmaltolepisBlock;
import org.jurassicraft.server.block.plant.WestIndianLilacBlock;
import org.jurassicraft.server.block.plant.WildOnionBlock;
import org.jurassicraft.server.block.tree.AncientDoubleSlabBlock;
import org.jurassicraft.server.block.tree.AncientLeavesBlock;
import org.jurassicraft.server.block.tree.AncientLogBlock;
import org.jurassicraft.server.block.tree.AncientPlanksBlock;
import org.jurassicraft.server.block.tree.AncientSaplingBlock;
import org.jurassicraft.server.block.tree.AncientSlabHalfBlock;
import org.jurassicraft.server.block.tree.AncientStairsBlock;
import org.jurassicraft.server.block.tree.TreeType;
import org.jurassicraft.server.dinosaur.Dinosaur;
import org.jurassicraft.server.entity.EntityHandler;

public class BlockHandler {
    public static final Map<TreeType, AncientPlanksBlock> ANCIENT_PLANKS = new HashMap<TreeType, AncientPlanksBlock>();
    public static final Map<TreeType, AncientLogBlock> ANCIENT_LOGS = new HashMap<TreeType, AncientLogBlock>();
    public static final Map<TreeType, AncientLeavesBlock> ANCIENT_LEAVES = new HashMap<TreeType, AncientLeavesBlock>();
    public static final Map<TreeType, AncientSaplingBlock> ANCIENT_SAPLINGS = new HashMap<TreeType, AncientSaplingBlock>();
    public static final Map<TreeType, AncientSlabHalfBlock> ANCIENT_SLABS = new HashMap<TreeType, AncientSlabHalfBlock>();
    public static final Map<TreeType, AncientDoubleSlabBlock> ANCIENT_DOUBLE_SLABS = new HashMap<TreeType, AncientDoubleSlabBlock>();
    public static final Map<TreeType, AncientStairsBlock> ANCIENT_STAIRS = new HashMap<TreeType, AncientStairsBlock>();
    public static final Map<TreeType, AncientLogBlock> PETRIFIED_LOGS = new HashMap<TreeType, AncientLogBlock>();
    public static final List<FossilBlock> FOSSILS = new ArrayList<FossilBlock>();
    public static final List<EncasedFossilBlock> ENCASED_FOSSILS = new ArrayList<EncasedFossilBlock>();
    public static final PlantFossilBlock PLANT_FOSSIL = new PlantFossilBlock();
    public static final CleaningStationBlock CLEANING_STATION = new CleaningStationBlock();
    public static final FossilGrinderBlock FOSSIL_GRINDER = new FossilGrinderBlock();
    public static final DNASequencerBlock DNA_SEQUENCER = new DNASequencerBlock();
    public static final DNASynthesizerBlock DNA_SYNTHESIZER = new DNASynthesizerBlock();
    public static final EmbryonicMachineBlock EMBRYONIC_MACHINE = new EmbryonicMachineBlock();
    public static final EmbryoCalcificationMachineBlock EMBRYO_CALCIFICATION_MACHINE = new EmbryoCalcificationMachineBlock();
    public static final IncubatorBlock INCUBATOR = new IncubatorBlock();
    public static final DNAExtractorBlock DNA_EXTRACTOR = new DNAExtractorBlock();
    public static final DNACombinatorHybridizerBlock DNA_COMBINATOR_HYBRIDIZER = new DNACombinatorHybridizerBlock();
    public static final AmberBlock AMBER_ORE = new AmberBlock();
    public static final GypsumStoneBlock GYPSUM_STONE = new GypsumStoneBlock();
    public static final Block GYPSUM_COBBLESTONE = new BasicBlock(Material.field_151576_e).func_149711_c(1.5f);
    public static final Block GYPSUM_BRICKS = new BasicBlock(Material.field_151576_e).func_149711_c(2.0f);
    public static final Block REINFORCED_STONE = new BasicBlock(Material.field_151576_e).func_149711_c(2.0f);
    public static final Block REINFORCED_BRICKS = new BasicBlock(Material.field_151576_e).func_149711_c(3.0f);
    public static final CultivatorTopBlock CULTIVATOR_TOP = new CultivatorTopBlock();
    public static final CultivatorBottomBlock CULTIVATOR_BOTTOM = new CultivatorBottomBlock();
    public static final ActionFigureBlock ACTION_FIGURE = new ActionFigureBlock();
    public static final ClearGlassBlock CLEAR_GLASS = new ClearGlassBlock();
    public static final FossilizedTrackwayBlock FOSSILIZED_TRACKWAY = new FossilizedTrackwayBlock();
    public static final NestFossilBlock NEST_FOSSIL = new NestFossilBlock(false);
    public static final NestFossilBlock ENCASED_NEST_FOSSIL = new NestFossilBlock(true);
    public static final SmallRoyalFernBlock SMALL_ROYAL_FERN = new SmallRoyalFernBlock();
    public static final SmallChainFernBlock SMALL_CHAIN_FERN = new SmallChainFernBlock();
    public static final SmallCycadBlock SMALL_CYCAD = new SmallCycadBlock();
    public static final BennettitaleanCycadeoideaBlock CYCADEOIDEA = new BennettitaleanCycadeoideaBlock();
    public static final AncientPlantBlock CRY_PANSY = new AncientPlantBlock();
    public static final ScalyTreeFernBlock SCALY_TREE_FERN = new ScalyTreeFernBlock();
    public static final CycadZamitesBlock ZAMITES = new CycadZamitesBlock();
    public static final DicksoniaBlock DICKSONIA = new DicksoniaBlock();
    public static final DicroidiumZuberiBlock DICROIDIUM_ZUBERI = new DicroidiumZuberiBlock();
    public static final AjuginuculaSmithiiBlock AJUGINUCULA_SMITHII = new AjuginuculaSmithiiBlock();
    public static final WildOnionBlock WILD_ONION = new WildOnionBlock();
    public static final GracilariaBlock GRACILARIA = new GracilariaBlock();
    public static final DictyophyllumBlock DICTYOPHYLLUM = new DictyophyllumBlock();
    public static final WestIndianLilacBlock WEST_INDIAN_LILAC = new WestIndianLilacBlock();
    public static final SerennaVeriformansBlock SERENNA_VERIFORMANS = new SerennaVeriformansBlock();
    public static final LadiniaSimplexBlock LADINIA_SIMPLEX = new LadiniaSimplexBlock();
    public static final OrontiumMackiiBlock ORONTIUM_MACKII = new OrontiumMackiiBlock();
    public static final UmaltolepisBlock UMALTOLEPIS = new UmaltolepisBlock();
    public static final LiriodendritesBlock LIRIODENDRITES = new LiriodendritesBlock();
    public static final RaphaeliaBlock RAPHAELIA = new RaphaeliaBlock();
    public static final EncephalartosBlock ENCEPHALARTOS = new EncephalartosBlock();
    public static final PeatBlock PEAT = new PeatBlock();
    public static final Block PEAT_MOSS = new PeatMossBlock();
    public static final MossBlock MOSS = new MossBlock();
    public static final FeederBlock FEEDER = new FeederBlock();
    public static PaleoBaleBlock PALEO_BALE_CYCADEOIDEA;
    public static PaleoBaleBlock PALEO_BALE_CYCAD;
    public static PaleoBaleBlock PALEO_BALE_FERN;
    public static PaleoBaleBlock PALEO_BALE_LEAVES;
    public static PaleoBaleBlock PALEO_BALE_OTHER;

    public static void init() {
        BlockHandler.registerBlock(PLANT_FOSSIL, "Plant Fossil Block");
        BlockHandler.registerBlock(FOSSILIZED_TRACKWAY, "Fossilized Trackway");
        BlockHandler.registerBlock(NEST_FOSSIL, "Nest Fossil");
        BlockHandler.registerBlock(ENCASED_NEST_FOSSIL, "Encased Nest Fossil");
        for (int i = 0; i < (int)Math.ceil((float)EntityHandler.getHighestID() / 16.0f); ++i) {
            FossilBlock fossil = new FossilBlock(i * 16);
            EncasedFossilBlock encasedFossil = new EncasedFossilBlock(i * 16);
            FOSSILS.add(fossil);
            ENCASED_FOSSILS.add(encasedFossil);
            BlockHandler.registerBlock(fossil, "Fossil Block " + i);
            BlockHandler.registerBlock(encasedFossil, "Encased Fossil " + i);
            OreDictionary.registerOre((String)"fossil", (Block)fossil);
        }
        for (TreeType type : TreeType.values()) {
            BlockHandler.registerTreeType(type);
        }
        BlockHandler.registerBlock(AMBER_ORE, "Amber Ore");
        BlockHandler.registerBlock(GYPSUM_STONE, "Gypsum Stone");
        BlockHandler.registerBlock(GYPSUM_COBBLESTONE, "Gypsum Cobblestone");
        BlockHandler.registerBlock(GYPSUM_BRICKS, "Gypsum Bricks");
        BlockHandler.registerBlock(REINFORCED_STONE, "Reinforced Stone");
        BlockHandler.registerBlock(REINFORCED_BRICKS, "Reinforced Bricks");
        BlockHandler.registerBlock((Block)AJUGINUCULA_SMITHII, "Ajuginucula Smithii");
        BlockHandler.registerBlock((Block)SMALL_ROYAL_FERN, "Small Royal Fern");
        BlockHandler.registerBlock((Block)SMALL_CHAIN_FERN, "Small Chain Fern");
        BlockHandler.registerBlock((Block)SMALL_CYCAD, "Small Cycad");
        BlockHandler.registerBlock((Block)CYCADEOIDEA, "Bennettitalean Cycadeoidea");
        BlockHandler.registerBlock((Block)CRY_PANSY, "Cry Pansy");
        BlockHandler.registerBlock((Block)SCALY_TREE_FERN, "Scaly Tree Fern");
        BlockHandler.registerBlock((Block)ZAMITES, "Cycad Zamites");
        BlockHandler.registerBlock((Block)DICKSONIA, "Dicksonia");
        BlockHandler.registerBlock((Block)WILD_ONION, "Wild Onion Plant");
        BlockHandler.registerBlock((Block)GRACILARIA, "Gracilaria Seaweed");
        BlockHandler.registerBlock((Block)DICROIDIUM_ZUBERI, "Dicroidium Zuberi");
        BlockHandler.registerBlock((Block)DICTYOPHYLLUM, "Dictyophyllum");
        BlockHandler.registerBlock((Block)WEST_INDIAN_LILAC, "West Indian Lilac");
        BlockHandler.registerBlock((Block)SERENNA_VERIFORMANS, "Serenna Veriformans");
        BlockHandler.registerBlock((Block)LADINIA_SIMPLEX, "Ladinia Simplex");
        BlockHandler.registerBlock((Block)ORONTIUM_MACKII, "Orontium Mackii");
        BlockHandler.registerBlock((Block)UMALTOLEPIS, "Umaltolepis");
        BlockHandler.registerBlock((Block)LIRIODENDRITES, "Liriodendrites");
        BlockHandler.registerBlock((Block)RAPHAELIA, "Raphaelia");
        BlockHandler.registerBlock((Block)ENCEPHALARTOS, "Encephalartos");
        BlockHandler.registerBlock(MOSS, "Moss");
        BlockHandler.registerBlock(PEAT, "Peat");
        BlockHandler.registerBlock(PEAT_MOSS, "Peat Moss");
        BlockHandler.registerBlock((Block)CLEAR_GLASS, "Clear Glass");
        BlockHandler.registerBlockTileEntity(CleaningStationBlockEntity.class, (Block)CLEANING_STATION, "Cleaning Station");
        BlockHandler.registerBlockTileEntity(FossilGrinderBlockEntity.class, (Block)FOSSIL_GRINDER, "Fossil Grinder");
        BlockHandler.registerBlockTileEntity(DNASequencerBlockEntity.class, (Block)DNA_SEQUENCER, "DNA Sequencer");
        BlockHandler.registerBlockTileEntity(DNASynthesizerBlockEntity.class, (Block)DNA_SYNTHESIZER, "DNA Synthesizer");
        BlockHandler.registerBlockTileEntity(EmbryonicMachineBlockEntity.class, (Block)EMBRYONIC_MACHINE, "Embryonic Machine");
        BlockHandler.registerBlockTileEntity(EmbryoCalcificationMachineBlockEntity.class, (Block)EMBRYO_CALCIFICATION_MACHINE, "Embryo Calcification Machine");
        BlockHandler.registerBlockTileEntity(DNAExtractorBlockEntity.class, (Block)DNA_EXTRACTOR, "DNA Extractor");
        BlockHandler.registerBlockTileEntity(DNACombinatorHybridizerBlockEntity.class, (Block)DNA_COMBINATOR_HYBRIDIZER, "DNA Combinator Hybridizer");
        BlockHandler.registerBlockTileEntity(IncubatorBlockEntity.class, (Block)INCUBATOR, "Incubator");
        BlockHandler.registerBlockTileEntity(ActionFigureBlockEntity.class, (Block)ACTION_FIGURE, "Action Figure Block");
        BlockHandler.registerBlockTileEntity(FeederBlockEntity.class, (Block)FEEDER, "Feeder");
        PALEO_BALE_CYCADEOIDEA = new PaleoBaleBlock(PaleoBaleBlock.Variant.CYCADEOIDEA);
        PALEO_BALE_CYCAD = new PaleoBaleBlock(PaleoBaleBlock.Variant.CYCAD);
        PALEO_BALE_FERN = new PaleoBaleBlock(PaleoBaleBlock.Variant.FERN);
        PALEO_BALE_LEAVES = new PaleoBaleBlock(PaleoBaleBlock.Variant.LEAVES);
        PALEO_BALE_OTHER = new PaleoBaleBlock(PaleoBaleBlock.Variant.OTHER);
        BlockHandler.registerBlock((Block)PALEO_BALE_OTHER, "Paleo Bale Other");
        BlockHandler.registerBlock((Block)PALEO_BALE_CYCADEOIDEA, "Paleo Bale Cycadeoidea");
        BlockHandler.registerBlock((Block)PALEO_BALE_CYCAD, "Paleo Bale Cycad");
        BlockHandler.registerBlock((Block)PALEO_BALE_FERN, "Paleo Bale Fern");
        BlockHandler.registerBlock((Block)PALEO_BALE_LEAVES, "Paleo Bale Leaves");
    }

    public static void registerTreeType(TreeType type) {
        AncientPlanksBlock planks = new AncientPlanksBlock(type);
        AncientLogBlock log = new AncientLogBlock(type, false);
        AncientLogBlock petrified_log = new AncientLogBlock(type, true);
        AncientLeavesBlock leaves = new AncientLeavesBlock(type);
        AncientSaplingBlock sapling = new AncientSaplingBlock(type);
        AncientStairsBlock stair = new AncientStairsBlock(type, planks.func_176223_P());
        AncientSlabHalfBlock slab = new AncientSlabHalfBlock(type, planks.func_176223_P());
        AncientDoubleSlabBlock double_slab = new AncientDoubleSlabBlock(type, (Block)slab, planks.func_176223_P());
        ANCIENT_PLANKS.put(type, planks);
        ANCIENT_LOGS.put(type, log);
        ANCIENT_LEAVES.put(type, leaves);
        ANCIENT_SAPLINGS.put(type, sapling);
        ANCIENT_STAIRS.put(type, stair);
        ANCIENT_SLABS.put(type, slab);
        ANCIENT_DOUBLE_SLABS.put(type, double_slab);
        PETRIFIED_LOGS.put(type, petrified_log);
        String typeName = type.name();
        BlockHandler.registerBlock(planks, typeName + " Planks");
        BlockHandler.registerBlock((Block)log, typeName + " Log");
        BlockHandler.registerBlock((Block)petrified_log, typeName + " Log Petrified");
        BlockHandler.registerBlock((Block)leaves, typeName + " Leaves");
        BlockHandler.registerBlock((Block)sapling, typeName + " Sapling");
        BlockHandler.registerBlock((Block)stair, typeName + " Stairs");
        BlockHandler.registerBlock((Block)slab, typeName + " Slab");
        BlockHandler.registerBlock((Block)double_slab, typeName + " Double Slab");
        OreDictionary.registerOre((String)"logWood", (Block)log);
        OreDictionary.registerOre((String)"logWood", (Block)petrified_log);
        OreDictionary.registerOre((String)"plankWood", (Block)planks);
        OreDictionary.registerOre((String)"treeLeaves", (Block)leaves);
        OreDictionary.registerOre((String)"treeSapling", (Block)sapling);
        OreDictionary.registerOre((String)"slabWood", (Block)slab);
        OreDictionary.registerOre((String)"stairWood", (Block)stair);
        Blocks.field_150480_ab.func_180686_a((Block)leaves, 30, 60);
        Blocks.field_150480_ab.func_180686_a((Block)planks, 5, 20);
        Blocks.field_150480_ab.func_180686_a((Block)log, 5, 5);
        Blocks.field_150480_ab.func_180686_a((Block)petrified_log, 5, 5);
        Blocks.field_150480_ab.func_180686_a((Block)double_slab, 5, 20);
        Blocks.field_150480_ab.func_180686_a((Block)slab, 5, 20);
        Blocks.field_150480_ab.func_180686_a((Block)stair, 5, 20);
    }

    public static FossilBlock getFossilBlock(Dinosaur dinosaur) {
        return BlockHandler.getFossilBlock(EntityHandler.getDinosaurId(dinosaur));
    }

    private static int getBlockId(int id) {
        return (int)Math.floor(((float)id + 1.0f) / 16.0f - 0.0625f);
    }

    public static EncasedFossilBlock getEncasedFossil(Dinosaur dinosaur) {
        return BlockHandler.getEncasedFossil(EntityHandler.getDinosaurId(dinosaur));
    }

    public static EncasedFossilBlock getEncasedFossil(int id) {
        return ENCASED_FOSSILS.get(BlockHandler.getBlockId(id));
    }

    public static FossilBlock getFossilBlock(int id) {
        return FOSSILS.get(BlockHandler.getBlockId(id));
    }

    public static int getDinosaurId(FossilBlock fossil, int metadata) {
        return FOSSILS.indexOf(fossil) * 16 + metadata;
    }

    public static int getDinosaurId(EncasedFossilBlock fossil, int metadata) {
        return ENCASED_FOSSILS.indexOf(fossil) * 16 + metadata;
    }

    public static int getMetadata(int id) {
        return id % 16;
    }

    public static int getMetadata(Dinosaur dinosaur) {
        return BlockHandler.getMetadata(EntityHandler.getDinosaurId(dinosaur));
    }

    public static void registerBlockTileEntity(Class<? extends TileEntity> tileEntity, Block block, String name) {
        BlockHandler.registerBlock(block, name);
        GameRegistry.registerTileEntity(tileEntity, (String)("jurassicraft:" + name.toLowerCase(Locale.ENGLISH).replaceAll(" ", "_")));
    }

    public static void registerBlock(Block block, String name) {
        name = name.toLowerCase(Locale.ENGLISH).replaceAll(" ", "_");
        block.func_149663_c(name);
        ResourceLocation resource = new ResourceLocation("jurassicraft", name);
        if (block instanceof SubBlocksBlock) {
            GameRegistry.register((IForgeRegistryEntry)block, (ResourceLocation)resource);
            GameRegistry.register((IForgeRegistryEntry)((SubBlocksBlock)block).getItemBlock(), (ResourceLocation)resource);
        } else {
            GameRegistry.register((IForgeRegistryEntry)block, (ResourceLocation)resource);
            GameRegistry.register((IForgeRegistryEntry)new ItemBlock(block), (ResourceLocation)resource);
        }
    }
}

