/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.block.entity;

import java.util.List;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import org.jurassicraft.server.block.entity.MachineBaseBlockEntity;
import org.jurassicraft.server.container.DNAExtractorContainer;
import org.jurassicraft.server.dinosaur.Dinosaur;
import org.jurassicraft.server.entity.EntityHandler;
import org.jurassicraft.server.genetics.DinoDNA;
import org.jurassicraft.server.genetics.GeneticsHelper;
import org.jurassicraft.server.genetics.PlantDNA;
import org.jurassicraft.server.item.ItemHandler;
import org.jurassicraft.server.plant.Plant;
import org.jurassicraft.server.plant.PlantHandler;

public class DNAExtractorBlockEntity
extends MachineBaseBlockEntity {
    private static final int[] INPUTS = new int[]{0, 1};
    private static final int[] OUTPUTS = new int[]{2, 3, 4, 5};
    private ItemStack[] slots = new ItemStack[6];

    @Override
    protected int getProcess(int slot) {
        return 0;
    }

    @Override
    protected boolean canProcess(int process) {
        ItemStack extraction = this.slots[0];
        ItemStack storage = this.slots[1];
        if (!(storage == null || storage.func_77973_b() != ItemHandler.STORAGE_DISC || extraction == null || extraction.func_77973_b() != ItemHandler.AMBER && extraction.func_77973_b() != ItemHandler.SEA_LAMPREY && extraction.func_77973_b() != ItemHandler.DINOSAUR_MEAT || storage.func_77978_p() != null && storage.func_77978_p().func_74764_b("Genetics"))) {
            for (int i = 2; i < 6; ++i) {
                if (this.slots[i] != null) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected void processItem(int process) {
        if (this.canProcess(process)) {
            Random rand = this.field_145850_b.field_73012_v;
            ItemStack input = this.slots[0];
            ItemStack disc = null;
            Item item = input.func_77973_b();
            if (item == ItemHandler.AMBER || item == ItemHandler.SEA_LAMPREY) {
                if (input.func_77952_i() == 0) {
                    List<Dinosaur> possibleDinos = item == ItemHandler.AMBER ? EntityHandler.getDinosaursFromAmber() : EntityHandler.getDinosaursFromSeaLampreys();
                    Dinosaur dino = possibleDinos.get(rand.nextInt(possibleDinos.size()));
                    int dinosaurId = EntityHandler.getDinosaurId(dino);
                    disc = new ItemStack((Item)ItemHandler.STORAGE_DISC, 1, dinosaurId);
                    int quality = (rand.nextInt(10) + 1) * 5;
                    if (rand.nextInt(2) > 0) {
                        quality += 50;
                    }
                    DinoDNA dna = new DinoDNA(dino, quality, GeneticsHelper.randomGenetics(rand));
                    NBTTagCompound nbt = new NBTTagCompound();
                    dna.writeToNBT(nbt);
                    disc.func_77982_d(nbt);
                } else if (input.func_77952_i() == 1) {
                    List<Plant> possiblePlants = PlantHandler.getPrehistoricPlants();
                    Plant plant = possiblePlants.get(rand.nextInt(possiblePlants.size()));
                    int plantId = PlantHandler.getPlantId(plant);
                    disc = new ItemStack((Item)ItemHandler.STORAGE_DISC, 1, plantId);
                    int quality = (rand.nextInt(10) + 1) * 5;
                    if (rand.nextInt(2) > 0) {
                        quality += 50;
                    }
                    PlantDNA dna = new PlantDNA(plantId, quality);
                    NBTTagCompound nbt = new NBTTagCompound();
                    dna.writeToNBT(nbt);
                    disc.func_77982_d(nbt);
                }
            } else if (item == ItemHandler.DINOSAUR_MEAT) {
                disc = new ItemStack((Item)ItemHandler.STORAGE_DISC, 1, input.func_77952_i());
                disc.func_77982_d(input.func_77978_p());
            }
            int empty = this.getOutputSlot(disc);
            this.mergeStack(empty, disc);
            this.decreaseStackSize(0);
            this.decreaseStackSize(1);
        }
    }

    @Override
    protected int getMainOutput(int process) {
        return 2;
    }

    @Override
    protected int getStackProcessTime(ItemStack stack) {
        return 2000;
    }

    @Override
    protected int getProcessCount() {
        return 1;
    }

    @Override
    protected int[] getInputs() {
        return INPUTS;
    }

    @Override
    protected int[] getInputs(int process) {
        return this.getInputs();
    }

    @Override
    protected int[] getOutputs() {
        return OUTPUTS;
    }

    @Override
    protected ItemStack[] getSlots() {
        return this.slots;
    }

    @Override
    protected void setSlots(ItemStack[] slots) {
        this.slots = slots;
    }

    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        return new DNAExtractorContainer(playerInventory, (TileEntity)this);
    }

    public String func_174875_k() {
        return "jurassicraft:dna_extractor";
    }

    public String func_70005_c_() {
        return this.func_145818_k_() ? this.customName : "container.dna_extractor";
    }
}

