/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.block.entity;

import java.util.Random;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntityLockable;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import org.jurassicraft.client.sound.SoundHandler;
import org.jurassicraft.server.block.machine.FeederBlock;
import org.jurassicraft.server.dinosaur.Dinosaur;
import org.jurassicraft.server.entity.DinosaurEntity;
import org.jurassicraft.server.food.FoodHelper;

public class FeederBlockEntity
extends TileEntityLockable
implements ITickable,
ISidedInventory {
    private static final int[] CARNIVOROUS_SLOTS = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
    private static final int[] HERBIVOROUS_SLOTS = new int[]{9, 10, 11, 12, 13, 14, 15, 16, 17};
    public int prevOpenAnimation;
    public int openAnimation;
    protected String customName;
    private ItemStack[] slots = new ItemStack[18];
    private int stayOpen;
    private boolean open;
    private DinosaurEntity feeding;
    private int feedingExpire;

    public Container func_174876_a(InventoryPlayer inventory, EntityPlayer player) {
        return null;
    }

    public String func_174875_k() {
        return "jurassicraft:feeder";
    }

    public int[] func_180463_a(EnumFacing side) {
        return side.func_176740_k() == EnumFacing.Axis.Y ? CARNIVOROUS_SLOTS : HERBIVOROUS_SLOTS;
    }

    public boolean func_180462_a(int index, ItemStack stack, EnumFacing direction) {
        return this.func_94041_b(index, stack);
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return true;
    }

    public int func_70302_i_() {
        return this.slots.length;
    }

    public ItemStack func_70301_a(int index) {
        return this.slots[index];
    }

    public ItemStack func_70298_a(int index, int count) {
        if (this.slots[index] != null) {
            if (this.slots[index].field_77994_a <= count) {
                ItemStack stack = this.slots[index];
                this.slots[index] = null;
                return stack;
            }
            ItemStack stack = this.slots[index].func_77979_a(count);
            if (this.slots[index].field_77994_a == 0) {
                this.slots[index] = null;
            }
            return stack;
        }
        return null;
    }

    public ItemStack func_70304_b(int index) {
        if (this.slots[index] != null) {
            ItemStack itemstack = this.slots[index];
            this.slots[index] = null;
            return itemstack;
        }
        return null;
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.slots[index] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) == this && player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return true;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public boolean func_145842_c(int id, int type) {
        if (id == 0) {
            boolean newOpen;
            boolean bl = newOpen = type == 1;
            if (newOpen != this.open) {
                this.field_145850_b.func_184134_a((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, SoundHandler.FEEDER, SoundCategory.BLOCKS, 1.0f, newOpen ? 1.0f : 0.9f, false);
            }
            this.open = newOpen;
            return true;
        }
        return super.func_145842_c(id, type);
    }

    public void func_174888_l() {
        for (int i = 0; i < this.slots.length; ++i) {
            this.slots[i] = null;
        }
    }

    public String func_70005_c_() {
        return this.func_145818_k_() ? this.customName : "container.feeder";
    }

    public boolean func_145818_k_() {
        return this.customName != null && this.customName.length() > 0;
    }

    public void setCustomInventoryName(String customName) {
        this.customName = customName;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        NBTTagList itemList = compound.func_150295_c("Items", 10);
        ItemStack[] slots = new ItemStack[this.slots.length];
        for (int i = 0; i < itemList.func_74745_c(); ++i) {
            NBTTagCompound item = itemList.func_150305_b(i);
            byte slot = item.func_74771_c("Slot");
            if (slot < 0 || slot >= slots.length) continue;
            slots[slot] = ItemStack.func_77949_a((NBTTagCompound)item);
        }
        if (compound.func_150297_b("CustomName", 8)) {
            this.customName = compound.func_74779_i("CustomName");
        }
        this.slots = slots;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound = super.func_189515_b(compound);
        NBTTagList itemList = new NBTTagList();
        for (int slot = 0; slot < this.func_70302_i_(); ++slot) {
            if (this.slots[slot] == null) continue;
            NBTTagCompound itemTag = new NBTTagCompound();
            itemTag.func_74774_a("Slot", (byte)slot);
            this.slots[slot].func_77955_b(itemTag);
            itemList.func_74742_a((NBTBase)itemTag);
        }
        compound.func_74782_a("Items", (NBTBase)itemList);
        if (this.func_145818_k_()) {
            compound.func_74778_a("CustomName", this.customName);
        }
        return compound;
    }

    public void func_73660_a() {
        this.prevOpenAnimation = this.openAnimation;
        if (this.open && this.openAnimation < 20) {
            ++this.openAnimation;
        } else if (!this.open && this.openAnimation > 0) {
            --this.openAnimation;
        }
        if (this.open && this.openAnimation == 19) {
            this.stayOpen = 20;
        }
        if (this.feeding != null && (this.feeding.isCarcass() || this.feeding.field_70128_L)) {
            this.feeding = null;
        }
        if (this.feeding != null) {
            if (this.feedingExpire > 0) {
                --this.feedingExpire;
            } else {
                this.feeding = null;
            }
        }
        if (this.open && this.openAnimation == 20) {
            if (this.stayOpen > 0) {
                --this.stayOpen;
                if (this.stayOpen == 10 && this.feeding != null) {
                    int feedSlot = this.getFoodForDinosaur(this.feeding.getDinosaur());
                    Random random = new Random();
                    float offsetX = 0.5f;
                    float offsetY = 0.5f;
                    float offsetZ = 0.5f;
                    float motionX = 0.0f;
                    float motionY = 0.0f;
                    float motionZ = 0.0f;
                    switch ((EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)FeederBlock.FACING)) {
                        case UP: {
                            offsetY = 1.0f;
                            motionY = 1.0f;
                            motionX = random.nextFloat() - 0.5f;
                            motionZ = random.nextFloat() - 0.5f;
                            break;
                        }
                        case DOWN: {
                            offsetY = -1.0f;
                            break;
                        }
                        case NORTH: {
                            offsetZ = -1.0f;
                            motionY = 0.5f;
                            motionZ = -0.5f;
                            break;
                        }
                        case SOUTH: {
                            offsetZ = 1.0f;
                            motionY = 0.5f;
                            motionZ = 0.5f;
                            break;
                        }
                        case WEST: {
                            offsetX = -1.0f;
                            motionY = 0.5f;
                            motionX = -0.5f;
                            break;
                        }
                        case EAST: {
                            offsetX = 1.0f;
                            motionY = 0.5f;
                            motionX = 0.5f;
                        }
                    }
                    ItemStack stack = this.slots[feedSlot];
                    if (stack != null) {
                        EntityItem itemEntity = new EntityItem(this.field_145850_b, (double)((float)this.field_174879_c.func_177958_n() + offsetX), (double)((float)this.field_174879_c.func_177956_o() + offsetY), (double)((float)this.field_174879_c.func_177952_p() + offsetZ), new ItemStack(stack.func_77973_b(), 1, stack.func_77952_i()));
                        itemEntity.func_174869_p();
                        itemEntity.field_70159_w = motionX * 0.3f;
                        itemEntity.field_70181_x = motionY * 0.3f;
                        itemEntity.field_70179_y = motionZ * 0.3f;
                        this.field_145850_b.func_72838_d((Entity)itemEntity);
                        this.func_70298_a(feedSlot, 1);
                        this.feeding.func_70661_as().func_75492_a(itemEntity.field_70165_t + (double)motionX, itemEntity.field_70163_u + (double)motionY, itemEntity.field_70161_v + (double)motionZ, 0.8);
                    }
                    this.feeding = null;
                }
            } else if (!this.field_145850_b.field_72995_K) {
                this.setOpen(false);
            }
        }
    }

    public void setOpen(boolean open) {
        if (!this.field_145850_b.field_72995_K && this.open != open) {
            this.field_145850_b.func_175641_c(this.field_174879_c, this.func_145838_q(), 0, open ? 1 : 0);
        }
        this.open = open;
        if (!open) {
            this.feeding = null;
        }
    }

    public boolean canFeedDinosaur(Dinosaur dinosaur) {
        return this.getFoodForDinosaur(dinosaur) != -1;
    }

    private int getFoodForDinosaur(Dinosaur dinosaur) {
        int i = 0;
        for (ItemStack stack : this.slots) {
            if (stack != null && stack.field_77994_a > 0 && FoodHelper.isEdible(dinosaur.getDiet(), stack.func_77973_b())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public DinosaurEntity getFeeding() {
        return this.feeding;
    }

    public void setFeeding(DinosaurEntity feeding) {
        this.feeding = feeding;
        this.feedingExpire = this.feeding != null ? 400 : 0;
    }
}

