/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.block.tree;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jurassicraft.server.block.BlockHandler;
import org.jurassicraft.server.block.tree.TreeType;
import org.jurassicraft.server.tab.TabHandler;

public class AncientLeavesBlock
extends BlockLeaves {
    private TreeType treeType;

    public AncientLeavesBlock(TreeType type) {
        this.treeType = type;
        this.func_149663_c(type.name().toLowerCase(Locale.ENGLISH) + "_leaves");
        this.func_149711_c(0.2f);
        this.func_149713_g(1);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)field_176236_b, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)field_176237_a, (Comparable)Boolean.valueOf(false)));
        this.func_149647_a(TabHandler.PLANTS);
    }

    public TreeType getTreeType() {
        return this.treeType;
    }

    protected void func_176234_a(World world, BlockPos pos, IBlockState state, int chance) {
    }

    public boolean func_149662_c(IBlockState state) {
        return Blocks.field_150362_t.func_149662_c(state);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return Blocks.field_150362_t.func_180664_k();
    }

    public boolean func_176214_u() {
        return Blocks.field_150362_t.func_176214_u();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return Blocks.field_150362_t.func_176225_a(state, world, pos, side);
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        Random rand = world instanceof World ? ((World)world).field_73012_v : new Random();
        int chance = this.func_176232_d(state);
        if (fortune > 0 && (chance -= 2 << fortune) < 10) {
            chance = 10;
        }
        if (rand.nextInt(chance) == 0) {
            drops.add(new ItemStack(this.func_180660_a(state, rand, fortune), 1, this.func_180651_a(state)));
        }
        this.captureDrops(true);
        drops.addAll(this.captureDrops(false));
        return drops;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)((Block)BlockHandler.ANCIENT_SAPLINGS.get((Object)this.treeType)));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, List<ItemStack> list) {
        list.add(new ItemStack(item, 1, 0));
    }

    public IBlockState func_176203_a(int meta) {
        boolean dec = meta < 4;
        boolean check = meta < 8;
        return this.func_176223_P().func_177226_a((IProperty)field_176237_a, (Comparable)Boolean.valueOf(dec)).func_177226_a((IProperty)field_176236_b, (Comparable)Boolean.valueOf(check));
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        if (!((Boolean)state.func_177229_b((IProperty)field_176237_a)).booleanValue()) {
            i = 4;
        }
        if (!((Boolean)state.func_177229_b((IProperty)field_176236_b)).booleanValue()) {
            i = 8;
        }
        return i;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{field_176236_b, field_176237_a});
    }

    public int func_180651_a(IBlockState state) {
        return 0;
    }

    public List<ItemStack> onSheared(ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        return Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((Block)this, 1, 0)});
    }

    public BlockPlanks.EnumType func_176233_b(int meta) {
        return BlockPlanks.EnumType.BIRCH;
    }
}

