/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.entity;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import org.jurassicraft.server.entity.DinosaurEntity;
import org.jurassicraft.server.util.GameRuleHandler;

public class MetabolismContainer {
    public static final int MAX_DIGESTION_AMOUNT = 3000;
    private final int MAX_ENERGY;
    private final int MAX_WATER;
    private int energy;
    private int digestingFood;
    private int water;
    private DinosaurEntity dinosaur;

    public MetabolismContainer(DinosaurEntity dinosaur) {
        this.dinosaur = dinosaur;
        double health = dinosaur.getDinosaur().getAdultHealth();
        this.MAX_ENERGY = (int)(health / 15.0 * 24000.0);
        this.MAX_WATER = (int)(health / 15.0 * 24000.0);
        this.energy = this.MAX_ENERGY;
        this.water = this.MAX_WATER;
    }

    public void update() {
        if (!this.dinosaur.field_70128_L && !this.dinosaur.isCarcass() && GameRuleHandler.DINO_METABOLISM.getBoolean(this.dinosaur.field_70170_p)) {
            this.decreaseEnergy(1);
            this.decreaseWater(1);
            if (this.dinosaur.func_70026_G()) {
                this.water = this.MAX_WATER;
            }
            if (this.digestingFood > 0) {
                this.increaseEnergy(10);
                --this.digestingFood;
            }
        }
    }

    public int getWater() {
        return this.water;
    }

    public void setWater(int water) {
        this.water = Math.min(water, this.MAX_WATER);
    }

    public int getEnergy() {
        return this.energy;
    }

    public void setEnergy(int energy) {
        this.energy = Math.min(energy, this.MAX_ENERGY);
    }

    public int getDigestingFood() {
        return this.digestingFood;
    }

    public void decreaseEnergy(int amount) {
        this.energy -= amount;
        this.energy = Math.max(0, this.energy);
        if (this.isStarving() && this.dinosaur.field_70173_aa % 10 == 0) {
            this.dinosaur.func_70097_a(DamageSource.field_76366_f, 5.0f);
        }
    }

    public void decreaseWater(int amount) {
        this.water -= amount;
        this.water = Math.max(0, this.water);
        if (this.isDehydrated() && this.dinosaur.field_70173_aa % 10 == 0) {
            this.dinosaur.func_70097_a(DamageSource.field_76366_f, 5.0f);
        }
    }

    public void setDigestingFoodAmount(int digesting) {
        this.digestingFood = Math.min(digesting, 3000);
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.water = nbt.func_74762_e("Water");
        this.energy = nbt.func_74762_e("Energy");
        this.digestingFood = nbt.func_74762_e("DigestingFood");
    }

    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("Water", this.water);
        nbt.func_74768_a("Energy", this.energy);
        nbt.func_74768_a("DigestingFood", this.digestingFood);
    }

    public int getMaxEnergy() {
        return this.MAX_ENERGY;
    }

    public int getMaxWater() {
        return this.MAX_WATER;
    }

    public void increaseEnergy(int amount) {
        this.setEnergy(this.energy + amount);
    }

    public void eat(int amount) {
        this.increaseEnergy(amount / 10);
        this.setDigestingFoodAmount(this.digestingFood + amount);
    }

    public void increaseWater(int amount) {
        this.setWater(this.water + amount);
    }

    public boolean isStarving() {
        return (double)this.energy < 200.0 && this.digestingFood <= 50;
    }

    public boolean isDehydrated() {
        return (double)this.water < 50.0;
    }

    public boolean isHungry() {
        return ((double)(this.energy + this.digestingFood * 10) < (double)this.MAX_ENERGY * 0.8 || this.energy < 50) && this.digestingFood + 500 < 3000;
    }

    public boolean isThirsty() {
        return (double)this.water < (double)this.MAX_WATER * 0.5;
    }
}

