/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.entity.ai.metabolism;

import net.minecraft.block.Block;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.item.Item;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jurassicraft.client.model.animation.DinosaurAnimation;
import org.jurassicraft.server.entity.DinosaurEntity;
import org.jurassicraft.server.entity.MetabolismContainer;
import org.jurassicraft.server.entity.ai.util.OnionTraverser;
import org.jurassicraft.server.food.FoodHelper;
import org.jurassicraft.server.util.GameRuleHandler;

public class GrazeEntityAI
extends EntityAIBase {
    public static final int EAT_RADIUS = 6;
    public static final int LOOK_RADIUS = 16;
    private static final int GIVE_UP_TIME = 200;
    private static final Logger LOGGER = LogManager.getLogger();
    protected DinosaurEntity dinosaur;
    protected BlockPos target;
    private int counter;
    private World world;
    private BlockPos previousTarget;
    private Vec3d targetVec;

    public GrazeEntityAI(DinosaurEntity dinosaur) {
        this.dinosaur = dinosaur;
    }

    public boolean func_75250_a() {
        return !this.dinosaur.field_70128_L && !this.dinosaur.isCarcass() && GameRuleHandler.DINO_METABOLISM.getBoolean(this.dinosaur.field_70170_p) && this.dinosaur.getMetabolism().isHungry() && this.dinosaur.getClosestFeeder() == null;
    }

    public void func_75249_e() {
        Vec3d headPos = this.dinosaur.getHeadPos();
        BlockPos head = new BlockPos(headPos.field_72450_a, headPos.field_72448_b, headPos.field_72449_c);
        this.world = this.dinosaur.field_70170_p;
        MetabolismContainer metabolism = this.dinosaur.getMetabolism();
        OnionTraverser traverser = new OnionTraverser(head, 16);
        this.target = null;
        for (BlockPos pos : traverser) {
            Block block = this.world.func_180495_p(pos).func_177230_c();
            if (!FoodHelper.isEdible(this.dinosaur.getDinosaur().getDiet(), block) || pos == this.previousTarget) continue;
            this.target = pos;
            this.targetVec = new Vec3d((double)this.target.func_177958_n(), (double)this.target.func_177956_o(), (double)this.target.func_177952_p());
            break;
        }
        if (this.target != null && metabolism.isStarving()) {
            this.dinosaur.func_70661_as().func_75492_a((double)this.target.func_177958_n(), (double)this.target.func_177956_o(), (double)this.target.func_177952_p(), 1.2);
        } else if (this.target != null) {
            this.dinosaur.func_70661_as().func_75492_a((double)this.target.func_177958_n(), (double)this.target.func_177956_o(), (double)this.target.func_177952_p(), 0.7);
        }
    }

    public boolean func_75253_b() {
        if (this.target != null && this.world.func_175623_d(this.target) && !this.dinosaur.func_70661_as().func_75500_f()) {
            this.terminateTask();
            return false;
        }
        return this.target != null;
    }

    public void func_75246_d() {
        if (this.target != null) {
            Vec3d headPos = this.dinosaur.getHeadPos();
            Vec3d headVec = new Vec3d(headPos.field_72450_a, (double)this.target.func_177956_o(), headPos.field_72449_c);
            if (headVec.func_72436_e(this.targetVec) < 6.0) {
                this.dinosaur.func_70661_as().func_75499_g();
                this.dinosaur.func_70671_ap().func_75650_a((double)this.target.func_177958_n(), (double)this.target.func_177956_o(), (double)this.target.func_177952_p(), 30.0f, (float)this.dinosaur.func_70646_bf());
                this.dinosaur.setAnimation(DinosaurAnimation.EATING.get());
                Item item = Item.func_150898_a((Block)this.world.func_180495_p(this.target).func_177230_c());
                this.world.func_175655_b(this.target, false);
                this.dinosaur.getMetabolism().eat(FoodHelper.getHealAmount(item));
                FoodHelper.applyEatEffects(this.dinosaur, item);
                this.dinosaur.func_70691_i(10.0f);
                this.previousTarget = null;
                this.terminateTask();
            } else {
                ++this.counter;
                if (this.counter >= 200) {
                    this.counter = 0;
                    this.previousTarget = this.target;
                    this.terminateTask();
                }
            }
        }
    }

    private void terminateTask() {
        this.dinosaur.func_70661_as().func_75499_g();
        this.target = null;
        this.dinosaur.setAnimation(DinosaurAnimation.IDLE.get());
    }
}

