/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.entity.dinosaur;

import net.ilexiconn.llibrary.server.animation.Animation;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import org.jurassicraft.client.model.animation.DinosaurAnimation;
import org.jurassicraft.client.sound.SoundHandler;
import org.jurassicraft.server.entity.DinosaurEntity;
import org.jurassicraft.server.entity.dinosaur.BrachiosaurusEntity;
import org.jurassicraft.server.entity.dinosaur.DilophosaurusEntity;
import org.jurassicraft.server.entity.dinosaur.GallimimusEntity;
import org.jurassicraft.server.entity.dinosaur.ParasaurolophusEntity;
import org.jurassicraft.server.entity.dinosaur.TriceratopsEntity;
import org.jurassicraft.server.entity.dinosaur.VelociraptorEntity;

public class TyrannosaurusEntity
extends DinosaurEntity {
    private int stepCount = 0;

    public TyrannosaurusEntity(World world) {
        super(world);
        this.target(EntityPlayer.class, EntityAnimal.class, EntityVillager.class, EntityMob.class, DilophosaurusEntity.class, GallimimusEntity.class, TriceratopsEntity.class, ParasaurolophusEntity.class, VelociraptorEntity.class, BrachiosaurusEntity.class);
    }

    @Override
    public SoundEvent getSoundForAnimation(Animation animation) {
        switch (DinosaurAnimation.getAnimation(animation)) {
            case SPEAK: {
                return SoundHandler.TYRANNOSAURUS_LIVING;
            }
            case CALLING: {
                return SoundHandler.TYRANNOSAURUS_ROAR;
            }
            case ROARING: {
                return SoundHandler.TYRANNOSAURUS_ROAR;
            }
            case DYING: {
                return SoundHandler.TYRANNOSAURUS_DEATH;
            }
            case INJURED: {
                return SoundHandler.TYRANNOSAURUS_HURT;
            }
        }
        return null;
    }

    @Override
    public SoundEvent getBreathingSound() {
        return SoundHandler.TYRANNOSAURUS_BREATHING;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70122_E && !this.isSwimming()) {
            if (this.field_70701_bs > 0.0f && this.stepCount <= 0) {
                this.func_184185_a(SoundHandler.STOMP, (float)this.interpolate(0.1f, 1.0), this.func_70647_i());
                this.stepCount = 65;
            }
            this.stepCount = (int)((double)this.stepCount - (double)this.field_70701_bs * 9.5);
        }
    }
}

