/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.entity.item;

import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import org.jurassicraft.server.dinosaur.Dinosaur;
import org.jurassicraft.server.entity.DinosaurEntity;
import org.jurassicraft.server.entity.EntityHandler;
import org.jurassicraft.server.item.ItemHandler;

public class DinosaurEggEntity
extends Entity
implements IEntityAdditionalSpawnData {
    private Dinosaur dinosaur;
    private int dnaQuality;
    private String genetics;
    private int hatchTime;

    public DinosaurEggEntity(World world, Dinosaur dinosaur, int dnaQuality, String genetics) {
        this(world);
        this.dinosaur = dinosaur;
        this.dnaQuality = dnaQuality;
        this.genetics = genetics;
    }

    public DinosaurEggEntity(World world) {
        super(world);
        this.func_70105_a(0.3f, 0.5f);
        this.hatchTime = this.randomWithRange(200, 300);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            --this.hatchTime;
            if (this.hatchTime <= 0) {
                this.hatch();
            }
            if (!this.field_70122_E) {
                this.field_70181_x -= 0.035;
            }
            this.field_70159_w *= 0.85;
            this.field_70181_x *= 0.85;
            this.field_70179_y *= 0.85;
            this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
        }
    }

    public void func_70088_a() {
    }

    public boolean func_70104_M() {
        return true;
    }

    public boolean func_70067_L() {
        return true;
    }

    public boolean func_184230_a(EntityPlayer player, ItemStack stack, EnumHand hand) {
        if (this.dinosaur != null && !this.field_70170_p.field_72995_K) {
            ItemStack eggStack = new ItemStack((Item)ItemHandler.EGG, 1, EntityHandler.getDinosaurId(this.dinosaur));
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74768_a("DNAQuality", this.dnaQuality);
            nbt.func_74778_a("Genetics", this.genetics);
            eggStack.func_77982_d(nbt);
            this.func_70099_a(eggStack, 0.1f);
            this.func_70106_y();
        }
        return true;
    }

    public void hatch() {
        if (!this.dinosaur.isMarineAnimal() && this.func_70090_H()) {
            this.warnPlayersWithinRadius("An egg is in the water and that animal is not aquatic!");
            this.hatchTime += 1000;
            return;
        }
        if (this.dinosaur.isMarineAnimal() && !this.func_70090_H()) {
            this.warnPlayersWithinRadius("An aquatic animals egg is on land!");
            this.hatchTime += 1000;
            return;
        }
        if (!(this.isNextBlockAir(1, 0, 0).booleanValue() && this.isNextBlockAir(0, 1, 0).booleanValue() && this.isNextBlockAir(0, 0, 1).booleanValue())) {
            this.warnPlayersWithinRadius("There is not enough space for the egg to hatch!");
            this.hatchTime += 1000;
            return;
        }
        try {
            DinosaurEntity entity = this.dinosaur.getDinosaurClass().getConstructor(World.class).newInstance(this.field_70170_p);
            entity.setAge(0);
            entity.setDNAQuality(this.dnaQuality);
            entity.setGenetics(this.genetics);
            entity.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            this.field_70170_p.func_72838_d((Entity)entity);
            entity.func_70642_aH();
            this.func_70106_y();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void warnPlayersWithinRadius(String message) {
        List players = this.field_70170_p.func_72872_a(EntityPlayer.class, new AxisAlignedBB(this.field_70165_t - 30.0, this.field_70163_u - 10.0, this.field_70161_v - 30.0, this.field_70165_t + 30.0, this.field_70163_u + 10.0, this.field_70161_v + 30.0));
        for (EntityPlayer player : players) {
            player.func_145747_a((ITextComponent)new TextComponentString(message));
        }
    }

    public int randomWithRange(int min, int max) {
        int range = max - min + 1;
        return (int)(Math.random() * (double)range) + min;
    }

    public Boolean isNextBlockAir(int xChange, int yChange, int zChange) {
        int blockX = MathHelper.func_76128_c((double)this.field_70165_t) + xChange;
        int blockY = MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) + yChange;
        int blockZ = MathHelper.func_76128_c((double)this.field_70161_v) + zChange;
        return this.field_70170_p.func_175623_d(new BlockPos(blockX, blockY, blockZ));
    }

    protected void func_70037_a(NBTTagCompound compound) {
        this.hatchTime = compound.func_74762_e("HatchTime");
        this.dinosaur = EntityHandler.getDinosaurById(compound.func_74762_e("Dinosaur"));
        this.dnaQuality = compound.func_74771_c("DNAQuality");
        this.genetics = compound.func_74779_i("Genetics");
    }

    protected void func_70014_b(NBTTagCompound compound) {
        compound.func_74768_a("Dinosaur", EntityHandler.getDinosaurId(this.dinosaur));
        compound.func_74768_a("HatchTime", this.hatchTime);
        compound.func_74774_a("DNAQuality", (byte)this.dnaQuality);
        compound.func_74778_a("Genetics", this.genetics);
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeInt(EntityHandler.getDinosaurId(this.dinosaur));
        buffer.writeByte(this.dnaQuality);
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.genetics);
    }

    public void readSpawnData(ByteBuf additionalData) {
        this.dinosaur = EntityHandler.getDinosaurById(additionalData.readInt());
        this.dnaQuality = additionalData.readByte();
        this.genetics = ByteBufUtils.readUTF8String((ByteBuf)additionalData);
    }

    public Dinosaur getDinosaur() {
        return this.dinosaur;
    }
}

