/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.entity.vehicle;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.MovementInput;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jurassicraft.JurassiCraft;
import org.jurassicraft.client.proxy.ClientProxy;
import org.jurassicraft.client.sound.CarSound;
import org.jurassicraft.server.entity.vehicle.modules.SeatEntity;
import org.jurassicraft.server.message.UpdateCarControlMessage;

public abstract class CarEntity
extends Entity {
    public static final DataParameter<Byte> WATCHER_STATE = EntityDataManager.func_187226_a(CarEntity.class, (DataSerializer)DataSerializers.field_187191_a);
    public static final DataParameter<Float> WATCHER_HEALTH = EntityDataManager.func_187226_a(CarEntity.class, (DataSerializer)DataSerializers.field_187193_c);
    public static final float MAX_HEALTH = 40.0f;
    public float wheelRotation;
    public float wheelRotateAmount;
    public float prevWheelRotateAmount;
    protected int interpProgress;
    protected double interpTargetX;
    protected double interpTargetY;
    protected double interpTargetZ;
    protected double interpTargetYaw;
    protected double interpTargetPitch;
    private Map<Integer, SeatEntity> seats = new HashMap<Integer, SeatEntity>();
    @SideOnly(value=Side.CLIENT)
    public CarSound sound;
    public float health;
    private float healAmount;
    private int healCooldown = 40;

    public CarEntity(World world) {
        super(world);
        this.func_70105_a(3.0f, 2.5f);
        this.field_70138_W = 1.5f;
        if (world.field_72995_K) {
            this.updateSound();
        }
        this.health = 40.0f;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (!this.func_180431_b(source)) {
            if (source.func_76346_g() instanceof EntityPlayer) {
                this.healAmount += (amount *= 10.0f);
                this.healCooldown = 40;
            }
            this.health -= amount;
            if (this.health < 0.0f) {
                this.func_70106_y();
            }
            return true;
        }
        return false;
    }

    public boolean func_70112_a(double dist) {
        return true;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            if (this.healCooldown > 0) {
                --this.healCooldown;
            } else if (this.healAmount > 0.0f) {
                this.health += 1.0f;
                this.healAmount -= 1.0f;
                if (this.health > 40.0f) {
                    this.health = 40.0f;
                    this.healAmount = 0.0f;
                }
            }
        }
        if (this.seats.size() == 0 && !this.field_70170_p.field_72995_K) {
            this.addSeat(new SeatEntity(this.field_70170_p, this, 0, -0.5f, 0.8f, 0.0f, 1.0f, 1.5f));
            this.addSeat(new SeatEntity(this.field_70170_p, this, 1, 0.5f, 0.8f, 0.0f, 1.0f, 1.5f));
            this.addSeat(new SeatEntity(this.field_70170_p, this, 2, -0.5f, 1.05f, 2.2f, 1.0f, 1.5f));
            this.addSeat(new SeatEntity(this.field_70170_p, this, 3, 0.5f, 1.05f, 2.2f, 1.0f, 1.5f));
            for (Map.Entry<Integer, SeatEntity> entry : this.seats.entrySet()) {
                this.field_70170_p.func_72838_d((Entity)entry.getValue());
            }
        }
        if (this.interpProgress > 0) {
            double interpolatedX = this.field_70165_t + (this.interpTargetX - this.field_70165_t) / (double)this.interpProgress;
            double interpolatedY = this.field_70163_u + (this.interpTargetY - this.field_70163_u) / (double)this.interpProgress;
            double interpolatedZ = this.field_70161_v + (this.interpTargetZ - this.field_70161_v) / (double)this.interpProgress;
            double deltaYaw = MathHelper.func_76138_g((double)(this.interpTargetYaw - (double)this.field_70177_z));
            this.field_70177_z = (float)((double)this.field_70177_z + deltaYaw / (double)this.interpProgress);
            this.field_70125_A = (float)((double)this.field_70125_A + (this.interpTargetPitch - (double)this.field_70125_A) / (double)this.interpProgress);
            --this.interpProgress;
            this.func_70107_b(interpolatedX, interpolatedY, interpolatedZ);
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
        }
        for (Map.Entry<Integer, SeatEntity> entry : this.seats.entrySet()) {
            entry.getValue().updateParent(this);
        }
        if (this.field_70170_p.field_72995_K) {
            this.updateKeyStates();
        } else if (this.getSeat(0) != null && this.getSeat(0).func_184179_bs() == null) {
            this.setState((byte)0);
        }
        if (!this.func_70090_H()) {
            float moveAmount = 0.0f;
            if ((this.left() || this.right()) && !this.forward() && !this.backward()) {
                moveAmount += 0.05f;
            }
            if (this.forward()) {
                moveAmount += 0.1f;
            } else if (this.backward()) {
                moveAmount -= 0.05f;
            }
            if (this.left()) {
                this.field_70177_z -= 26.0f * moveAmount;
            } else if (this.right()) {
                this.field_70177_z += 26.0f * moveAmount;
            }
            this.field_70159_w += (double)(MathHelper.func_76126_a((float)(-this.field_70177_z * ((float)Math.PI / 180))) * moveAmount);
            this.field_70179_y += (double)(MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180))) * moveAmount);
        }
        this.field_70181_x -= (double)0.1f;
        this.field_70159_w *= (double)0.85f;
        this.field_70181_x *= (double)0.85f;
        this.field_70179_y *= (double)0.85f;
        this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
        this.prevWheelRotateAmount = this.wheelRotateAmount;
        double deltaX = this.field_70165_t - this.field_70169_q;
        double deltaZ = this.field_70161_v - this.field_70166_s;
        float delta = MathHelper.func_76133_a((double)(deltaX * deltaX + deltaZ * deltaZ)) * 4.0f;
        if (delta > 1.0f) {
            delta = 1.0f;
        }
        this.wheelRotateAmount += (delta - this.wheelRotateAmount) * 0.4f;
        this.wheelRotation += this.wheelRotateAmount;
        if (!this.field_70170_p.field_72995_K) {
            this.field_70180_af.func_187227_b(WATCHER_HEALTH, (Object)Float.valueOf(this.health));
        } else {
            this.health = ((Float)this.field_70180_af.func_187225_a(WATCHER_HEALTH)).floatValue();
        }
    }

    private void updateKeyStates() {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (this.getSeat(0) != null && player == this.getSeat(0).func_184179_bs()) {
            MovementInput movementInput = player.field_71158_b;
            byte previous = this.getState();
            this.left(movementInput.field_187257_e);
            this.right(movementInput.field_187258_f);
            this.forward(movementInput.field_187255_c);
            this.backward(movementInput.field_187256_d);
            if (this.getState() != previous) {
                JurassiCraft.NETWORK_WRAPPER.sendToServer((IMessage)new UpdateCarControlMessage(this));
            }
        }
    }

    public boolean left() {
        return ((Byte)this.field_70180_af.func_187225_a(WATCHER_STATE) & 1) == 1;
    }

    public boolean right() {
        return ((Byte)this.field_70180_af.func_187225_a(WATCHER_STATE) >> 1 & 1) == 1;
    }

    public boolean forward() {
        return ((Byte)this.field_70180_af.func_187225_a(WATCHER_STATE) >> 2 & 1) == 1;
    }

    public boolean backward() {
        return ((Byte)this.field_70180_af.func_187225_a(WATCHER_STATE) >> 3 & 1) == 1;
    }

    public void left(boolean left) {
        this.setStateField(0, left);
    }

    public void right(boolean right) {
        this.setStateField(1, right);
    }

    public void forward(boolean forward) {
        this.setStateField(2, forward);
    }

    public void backward(boolean backward) {
        this.setStateField(3, backward);
    }

    private void setStateField(int i, boolean newState) {
        byte prevState = (Byte)this.field_70180_af.func_187225_a(WATCHER_STATE);
        if (newState) {
            this.field_70180_af.func_187227_b(WATCHER_STATE, (Object)((byte)(prevState | 1 << i)));
        } else {
            this.field_70180_af.func_187227_b(WATCHER_STATE, (Object)((byte)(prevState & ~(1 << i))));
        }
    }

    public byte getState() {
        return (Byte)this.field_70180_af.func_187225_a(WATCHER_STATE);
    }

    public void setState(byte state) {
        this.field_70180_af.func_187227_b(WATCHER_STATE, (Object)state);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(WATCHER_STATE, (Object)0);
        this.field_70180_af.func_187214_a(WATCHER_HEALTH, (Object)Float.valueOf(40.0f));
    }

    protected void func_70037_a(NBTTagCompound compound) {
        this.health = compound.func_74760_g("Health");
        this.healAmount = compound.func_74760_g("HealAmount");
    }

    protected void func_70014_b(NBTTagCompound compound) {
        compound.func_74776_a("Health", this.health);
        compound.func_74776_a("HealAmount", this.healAmount);
    }

    public AxisAlignedBB func_70114_g(Entity entity) {
        return this.func_174813_aQ();
    }

    public boolean func_70067_L() {
        return true;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        this.interpTargetX = x;
        this.interpTargetY = y;
        this.interpTargetZ = z;
        this.interpTargetYaw = yaw;
        this.interpTargetPitch = pitch;
        this.interpProgress = posRotationIncrements;
    }

    public EnumActionResult func_184199_a(EntityPlayer player, Vec3d vec, ItemStack stack, EnumHand hand) {
        Entity pointedEntity = null;
        double reach = 5.0;
        Vec3d look = player.func_70676_i(0.0f);
        Vec3d eyePosition = new Vec3d(player.field_70165_t, player.field_70163_u + (double)player.eyeHeight, player.field_70161_v);
        Vec3d vec3d2 = eyePosition.func_72441_c(look.field_72450_a * reach, look.field_72448_b * reach, look.field_72449_c * reach);
        List entities = this.field_70170_p.func_175674_a((Entity)player, player.func_174813_aQ().func_72321_a(look.field_72450_a * reach, look.field_72448_b * reach, look.field_72449_c * reach).func_72314_b(1.0, 1.0, 1.0), Predicates.and((Predicate)EntitySelectors.field_180132_d, entity -> entity != null && entity.func_70067_L() && entity instanceof SeatEntity));
        double distance = reach;
        for (Entity entity2 : entities) {
            double vecDistance;
            AxisAlignedBB bounds = entity2.func_174813_aQ().func_186662_g((double)entity2.func_70111_Y());
            RayTraceResult result = bounds.func_72327_a(eyePosition, vec3d2);
            if (bounds.func_72318_a(eyePosition)) {
                if (!(distance >= 0.0)) continue;
                pointedEntity = entity2;
                distance = 0.0;
                continue;
            }
            if (result == null || !((vecDistance = eyePosition.func_72438_d(result.field_72307_f)) < distance) && distance != 0.0) continue;
            if (entity2.func_184208_bv() == player.func_184208_bv() && !player.canRiderInteract()) {
                if (distance != 0.0) continue;
                pointedEntity = entity2;
                continue;
            }
            pointedEntity = entity2;
            distance = vecDistance;
        }
        if (pointedEntity != null) {
            return pointedEntity.func_184199_a(player, vec, stack, hand);
        }
        return EnumActionResult.PASS;
    }

    public void addSeat(SeatEntity entity) {
        this.seats.put(entity.getId(), entity);
    }

    public Entity getSeat(int id) {
        return this.seats.get(id);
    }

    public void func_70106_y() {
        super.func_70106_y();
        if (!this.field_70170_p.field_72995_K) {
            this.dropItems();
        } else {
            this.updateSound();
        }
    }

    private void updateSound() {
        if (!this.field_70128_L) {
            this.sound = new CarSound(this);
            ClientProxy.playSound(this);
        } else {
            ClientProxy.stopSound(this);
        }
    }

    public abstract void dropItems();
}

