/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.item.bones;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jurassicraft.server.api.GrindableItem;
import org.jurassicraft.server.api.Hybrid;
import org.jurassicraft.server.dinosaur.Dinosaur;
import org.jurassicraft.server.entity.EntityHandler;
import org.jurassicraft.server.item.ItemHandler;
import org.jurassicraft.server.tab.TabHandler;
import org.jurassicraft.server.util.LangHelper;

public class FossilItem
extends Item
implements GrindableItem {
    public static Map<String, List<Dinosaur>> fossilDinosaurs = new HashMap<String, List<Dinosaur>>();
    private String type;
    private boolean includeHybrids;

    public FossilItem(String type, boolean includeHybrids) {
        this.type = type.toLowerCase(Locale.ENGLISH).replaceAll(" ", "_");
        this.includeHybrids = includeHybrids;
        this.func_77627_a(true);
        this.func_77637_a(TabHandler.FOSSILS);
    }

    public static void init() {
        for (Dinosaur dinosaur : EntityHandler.getDinosaurs().values()) {
            String[] boneTypes;
            for (String boneType : boneTypes = dinosaur.getBones()) {
                List<Dinosaur> dinosaursWithType = fossilDinosaurs.get(boneType);
                if (dinosaursWithType == null) {
                    dinosaursWithType = new ArrayList<Dinosaur>();
                }
                dinosaursWithType.add(dinosaur);
                fossilDinosaurs.put(boneType, dinosaursWithType);
            }
        }
    }

    public String func_77653_i(ItemStack stack) {
        Dinosaur dinosaur = this.getDinosaur(stack);
        if (dinosaur != null) {
            return new LangHelper(this.func_77658_a() + ".name").withProperty("dino", "entity.jurassicraft." + dinosaur.getName().replace(" ", "_").toLowerCase(Locale.ENGLISH) + ".name").build();
        }
        return super.func_77653_i(stack);
    }

    public Dinosaur getDinosaur(ItemStack stack) {
        return EntityHandler.getDinosaurById(stack.func_77952_i());
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List<ItemStack> subtypes) {
        ArrayList<Dinosaur> dinosaurs = new ArrayList<Dinosaur>(EntityHandler.getRegisteredDinosaurs());
        Collections.sort(dinosaurs);
        List<Dinosaur> dinosaursForType = fossilDinosaurs.get(this.type);
        for (Dinosaur dinosaur : dinosaurs) {
            if (!dinosaur.shouldRegister() || !dinosaursForType.contains(dinosaur) || !this.includeHybrids && dinosaur instanceof Hybrid) continue;
            subtypes.add(new ItemStack(item, 1, EntityHandler.getDinosaurId(dinosaur)));
        }
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> lore, boolean advanced) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt != null && nbt.func_74764_b("Genetics") && nbt.func_74764_b("DNAQuality")) {
            int quality = nbt.func_74762_e("DNAQuality");
            TextFormatting colour = quality > 75 ? TextFormatting.GREEN : (quality > 50 ? TextFormatting.YELLOW : (quality > 25 ? TextFormatting.GOLD : TextFormatting.RED));
            lore.add(colour + new LangHelper("lore.dna_quality.name").withProperty("quality", quality + "").build());
            lore.add(TextFormatting.BLUE + new LangHelper("lore.genetic_code.name").withProperty("code", nbt.func_74779_i("Genetics")).build());
        }
    }

    @Override
    public boolean isGrindable(ItemStack stack) {
        return true;
    }

    @Override
    public ItemStack getGroundItem(ItemStack stack, Random random) {
        NBTTagCompound tag = stack.func_77978_p();
        int outputType = random.nextInt(6);
        if (outputType == 5 || stack.func_77977_a().contains("fresh")) {
            ItemStack output = new ItemStack((Item)ItemHandler.SOFT_TISSUE, 1, stack.func_77952_i());
            output.func_77982_d(tag);
            return output;
        }
        if (outputType < 3) {
            return new ItemStack(Items.field_151100_aR, 1, 15);
        }
        return new ItemStack(Items.field_151145_ak);
    }
}

