/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.tabula;

import com.google.gson.Gson;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.ilexiconn.llibrary.client.model.tabula.container.TabulaCubeContainer;
import net.ilexiconn.llibrary.client.model.tabula.container.TabulaCubeGroupContainer;
import net.ilexiconn.llibrary.client.model.tabula.container.TabulaModelContainer;

public class TabulaModelHelper {
    public static TabulaCubeContainer getCubeByName(String name, TabulaModelContainer model) {
        List<TabulaCubeContainer> allCubes = TabulaModelHelper.getAllCubes(model);
        for (TabulaCubeContainer cube : allCubes) {
            if (!cube.getName().equals(name)) continue;
            return cube;
        }
        return null;
    }

    public static TabulaCubeContainer getCubeByIdentifier(String identifier, TabulaModelContainer model) {
        List<TabulaCubeContainer> allCubes = TabulaModelHelper.getAllCubes(model);
        for (TabulaCubeContainer cube : allCubes) {
            if (!cube.getIdentifier().equals(identifier)) continue;
            return cube;
        }
        return null;
    }

    public static List<TabulaCubeContainer> getAllCubes(TabulaModelContainer model) {
        ArrayList<TabulaCubeContainer> cubes = new ArrayList<TabulaCubeContainer>();
        for (TabulaCubeGroupContainer cubeGroup : model.getCubeGroups()) {
            cubes.addAll(TabulaModelHelper.traverse(cubeGroup));
        }
        for (TabulaCubeContainer cube : model.getCubes()) {
            cubes.addAll(TabulaModelHelper.traverse(cube));
        }
        return cubes;
    }

    private static List<TabulaCubeContainer> traverse(TabulaCubeGroupContainer group) {
        ArrayList<TabulaCubeContainer> retCubes = new ArrayList<TabulaCubeContainer>();
        for (TabulaCubeContainer child : group.getCubes()) {
            retCubes.addAll(TabulaModelHelper.traverse(child));
        }
        for (TabulaCubeContainer child : group.getCubeGroups()) {
            retCubes.addAll(TabulaModelHelper.traverse((TabulaCubeGroupContainer)child));
        }
        return retCubes;
    }

    private static List<TabulaCubeContainer> traverse(TabulaCubeContainer cube) {
        ArrayList<TabulaCubeContainer> retCubes = new ArrayList<TabulaCubeContainer>();
        retCubes.add(cube);
        for (TabulaCubeContainer child : cube.getChildren()) {
            retCubes.addAll(TabulaModelHelper.traverse(child));
        }
        return retCubes;
    }

    public static TabulaModelContainer loadTabulaModel(String path) throws IOException {
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        if (!path.endsWith(".tbl")) {
            path = path + ".tbl";
        }
        InputStream stream = TabulaModelHelper.class.getResourceAsStream(path);
        return TabulaModelHelper.loadTabulaModel(TabulaModelHelper.getModelJsonStream(path, stream));
    }

    public static TabulaModelContainer loadTabulaModel(InputStream stream) {
        return (TabulaModelContainer)new Gson().fromJson((Reader)new InputStreamReader(stream), TabulaModelContainer.class);
    }

    private static InputStream getModelJsonStream(String name, InputStream file) throws IOException {
        ZipEntry entry;
        ZipInputStream zip = new ZipInputStream(file);
        while ((entry = zip.getNextEntry()) != null) {
            if (!entry.getName().equals("model.json")) continue;
            return zip;
        }
        throw new RuntimeException("No model.json present in " + name);
    }
}

