/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.world.tree;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLog;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import org.jurassicraft.server.block.BlockHandler;
import org.jurassicraft.server.block.tree.AncientLeavesBlock;
import org.jurassicraft.server.block.tree.AncientLogBlock;
import org.jurassicraft.server.block.tree.AncientSaplingBlock;
import org.jurassicraft.server.block.tree.TreeType;

public class CalamitesTreeGenerator
extends WorldGenAbstractTree {
    public CalamitesTreeGenerator() {
        super(true);
    }

    public boolean func_180709_b(World world, Random rand, BlockPos position) {
        IBlockState log = BlockHandler.ANCIENT_LOGS.get((Object)TreeType.CALAMITES).func_176223_P();
        IBlockState leaves = BlockHandler.ANCIENT_LEAVES.get((Object)TreeType.CALAMITES).func_176223_P();
        int height = rand.nextInt(10) + 10;
        int branchIndex = 0;
        int halfDistance = height / 2;
        for (int y = 0; y < height; ++y) {
            boolean branch;
            BlockPos logPos = position.func_177981_b(y);
            this.setBlockState(world, logPos, log);
            boolean upperHalf = y > halfDistance;
            if (++branchIndex > (upperHalf ? 2 : 3)) {
                branchIndex = 0;
            }
            boolean bl = upperHalf ? branchIndex >= 2 : (branch = branchIndex >= 3);
            if (!branch) continue;
            for (int face = 0; face < 4; ++face) {
                EnumFacing facing = EnumFacing.func_176731_b((int)face);
                BlockPos branchPos = logPos.func_177972_a(facing);
                IBlockState facingLog = log.func_177226_a((IProperty)AncientLogBlock.field_176299_a, (Comparable)BlockLog.EnumAxis.func_176870_a((EnumFacing.Axis)facing.func_176740_k()));
                this.setBlockState(world, branchPos, facingLog);
                this.setBlockState(world, branchPos.func_177984_a(), leaves);
                int leaveOut = Math.max(1, (upperHalf ? -(halfDistance - y) : halfDistance - y + halfDistance) / 2) + (rand.nextInt(2) - 1);
                for (int i = 0; i < leaveOut; ++i) {
                    BlockPos leavePos = branchPos.func_177967_a(facing, i + 1).func_177981_b(i / 2 + 1);
                    this.setBlockState(world, leavePos, leaves);
                    if (!upperHalf) {
                        if (i < leaveOut / 4 || height < 12) {
                            this.setBlockState(world, leavePos.func_177984_a(), leaves);
                        }
                        if (i < leaveOut - 2) {
                            this.setBlockState(world, leavePos.func_177977_b(), leaves);
                            this.setBlockState(world, leavePos.func_177972_a(facing.func_176735_f()), leaves);
                            this.setBlockState(world, leavePos.func_177972_a(facing.func_176746_e()), leaves);
                            continue;
                        }
                        if (i < leaveOut - 2) continue;
                        this.setBlockState(world, leavePos.func_177984_a(), leaves);
                        continue;
                    }
                    if (i < leaveOut - 1) continue;
                    this.setBlockState(world, leavePos.func_177984_a(), leaves);
                    this.setBlockState(world, leavePos.func_177981_b(1).func_177972_a(facing), leaves);
                }
                if (!upperHalf) {
                    this.setBlockState(world, branchPos.func_177972_a(facing).func_177984_a(), facingLog);
                    this.setBlockState(world, branchPos.func_177972_a(facing), leaves);
                    continue;
                }
                this.setBlockState(world, branchPos.func_177972_a(facing).func_177981_b(2), leaves);
            }
        }
        for (int i = 0; i < height / 4 + 1; ++i) {
            this.setBlockState(world, position.func_177981_b(height + i), leaves);
        }
        return true;
    }

    private void setBlockState(World world, BlockPos pos, IBlockState state) {
        Block block = world.func_180495_p(pos).func_177230_c();
        if (this.func_150523_a(block) || block instanceof AncientLeavesBlock || block instanceof AncientSaplingBlock || block instanceof AncientLogBlock) {
            world.func_175656_a(pos, state);
        }
    }
}

