/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.world.tree;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLog;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import org.jurassicraft.server.block.BlockHandler;
import org.jurassicraft.server.block.tree.AncientLeavesBlock;
import org.jurassicraft.server.block.tree.AncientLogBlock;
import org.jurassicraft.server.block.tree.AncientSaplingBlock;
import org.jurassicraft.server.block.tree.TreeType;

public class GinkgoTreeGenerator
extends WorldGenAbstractTree {
    public GinkgoTreeGenerator() {
        super(true);
    }

    public boolean func_180709_b(World world, Random rand, BlockPos position) {
        IBlockState log = BlockHandler.ANCIENT_LOGS.get((Object)TreeType.GINKGO).func_176223_P();
        IBlockState leaves = BlockHandler.ANCIENT_LEAVES.get((Object)TreeType.GINKGO).func_176223_P();
        int height = rand.nextInt(16) + 4;
        for (int y = 0; y < height; ++y) {
            BlockPos logPos = position.func_177981_b(y);
            this.setBlockState(world, logPos, log);
            int branchLength = Math.max(1, (height - y) / 3);
            if (y >= 2) {
                for (int x = -1; x <= 1; ++x) {
                    for (int z = -1; z <= 1; ++z) {
                        if (x == 0 && z == 0) continue;
                        this.setBlockState(world, logPos.func_177982_a(x, 0, z), leaves);
                    }
                }
                int bushSize = (int)((double)branchLength * 0.8);
                for (int x = -bushSize; x <= bushSize; ++x) {
                    for (int z = -bushSize; z <= bushSize; ++z) {
                        if (x == 0 && z == 0 || !(Math.sqrt(x * x + z * z) < (double)bushSize)) continue;
                        this.setBlockState(world, logPos.func_177982_a(x, 0, z), leaves);
                    }
                }
            }
            if (y % 3 != 2) continue;
            for (int face = 0; face < 4; ++face) {
                EnumFacing facing = EnumFacing.func_176731_b((int)face);
                BlockPos branchPos = logPos.func_177972_a(facing);
                IBlockState facingLog = log.func_177226_a((IProperty)AncientLogBlock.field_176299_a, (Comparable)BlockLog.EnumAxis.func_176870_a((EnumFacing.Axis)facing.func_176740_k()));
                this.setBlockState(world, branchPos, facingLog);
                this.setBlockState(world, branchPos.func_177981_b(2), leaves);
                this.setBlockState(world, branchPos.func_177977_b(), leaves);
                this.setBlockState(world, branchPos.func_177967_a(facing.func_176746_e(), 2), leaves);
                this.setBlockState(world, branchPos.func_177967_a(facing.func_176735_f(), 2), leaves);
                for (int i = 0; i < branchLength; ++i) {
                    BlockPos pos = branchPos.func_177967_a(facing, i + 1).func_177981_b(i / 2 + 1);
                    this.setBlockState(world, pos, facingLog);
                    this.setBlockState(world, pos.func_177984_a(), leaves);
                    this.setBlockState(world, pos.func_177977_b(), leaves);
                    this.setBlockState(world, pos.func_177972_a(facing.func_176746_e()), leaves);
                    this.setBlockState(world, pos.func_177972_a(facing.func_176735_f()), leaves);
                    if (i < branchLength - 1) continue;
                    this.setBlockState(world, pos.func_177972_a(facing), leaves);
                }
            }
        }
        this.setBlockState(world, position.func_177981_b(height), leaves);
        this.setBlockState(world, position.func_177981_b(height).func_177978_c(), leaves);
        this.setBlockState(world, position.func_177981_b(height).func_177968_d(), leaves);
        this.setBlockState(world, position.func_177981_b(height).func_177976_e(), leaves);
        this.setBlockState(world, position.func_177981_b(height).func_177974_f(), leaves);
        this.setBlockState(world, position.func_177981_b(height + 1), leaves);
        return true;
    }

    private void setBlockState(World world, BlockPos pos, IBlockState state) {
        Block block = world.func_180495_p(pos).func_177230_c();
        if (this.func_150523_a(block) || block instanceof AncientLeavesBlock || block instanceof AncientSaplingBlock || block instanceof AncientLogBlock) {
            world.func_175656_a(pos, state);
        }
    }
}

