/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.client.model;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.ilexiconn.llibrary.client.model.tabula.ITabulaModelAnimator;
import net.ilexiconn.llibrary.client.model.tabula.TabulaModel;
import net.ilexiconn.llibrary.client.model.tabula.container.TabulaModelContainer;
import net.ilexiconn.llibrary.client.model.tools.AdvancedModelRenderer;
import net.minecraft.entity.Entity;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jurassicraft.server.entity.DinosaurEntity;

@SideOnly(value=Side.CLIENT)
public class DinosaurModel
extends TabulaModel {
    public DinosaurModel(TabulaModelContainer model) {
        this(model, null);
    }

    public DinosaurModel(TabulaModelContainer model, ITabulaModelAnimator animator) {
        super(model, animator);
    }

    public void func_78087_a(float limbSwing, float limbSwingAmount, float rotation, float rotationYaw, float rotationPitch, float partialTicks, Entity entity) {
        DinosaurEntity dinosaur = (DinosaurEntity)entity;
        if (dinosaur.isCarcass()) {
            this.setMovementScale(0.0f);
        } else {
            this.setMovementScale(dinosaur.isSleeping() ? 0.5f : 1.0f);
        }
        super.func_78087_a(limbSwing, limbSwingAmount, rotation, rotationYaw, rotationPitch, partialTicks, entity);
    }

    public String[] getCubeIdentifierArray() {
        String[] cubeIdentifiers = new String[this.identifierMap.size()];
        int index = 0;
        Set identifiers = this.identifierMap.keySet();
        Iterator iterator = identifiers.iterator();
        while (iterator.hasNext()) {
            String identifier;
            cubeIdentifiers[index] = identifier = (String)iterator.next();
            ++index;
        }
        return cubeIdentifiers;
    }

    public Map<String, AdvancedModelRenderer> getIdentifierCubes() {
        return this.identifierMap;
    }

    public void faceTarget(float yaw, float pitch, float rotationDivisor, AdvancedModelRenderer ... boxes) {
        float actualRotationDivisor = rotationDivisor * (float)boxes.length;
        float yawAmount = yaw / 57.295776f / actualRotationDivisor;
        float pitchAmount = pitch / 57.295776f / actualRotationDivisor;
        for (AdvancedModelRenderer box : boxes) {
            box.field_78796_g += yawAmount;
            box.field_78795_f += pitchAmount;
        }
    }
}

