/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.client.model.animation;

import java.util.Map;
import net.ilexiconn.llibrary.server.animation.Animation;
import org.jurassicraft.client.model.animation.AnimationPass;
import org.jurassicraft.client.model.animation.DinosaurAnimation;
import org.jurassicraft.client.model.animation.PosedCuboid;
import org.jurassicraft.server.entity.DinosaurEntity;

public class MovementAnimationPass
extends AnimationPass {
    public MovementAnimationPass(Map<Animation, float[][]> poseSequences, PosedCuboid[][] poses, boolean useInertialTweens) {
        super(poseSequences, poses, useInertialTweens);
    }

    @Override
    protected boolean isEntityAnimationDependent() {
        return false;
    }

    @Override
    protected float getAnimationSpeed(DinosaurEntity entity) {
        return this.isMoving(entity) ? this.getAnimationDegree(entity) : 3.0f;
    }

    @Override
    protected float getAnimationDegree(DinosaurEntity entity) {
        float degree;
        if (this.animation == DinosaurAnimation.WALKING.get() || this.animation == DinosaurAnimation.RUNNING.get() || this.animation == DinosaurAnimation.SWIMMING.get()) {
            degree = entity.func_70090_H() || entity.func_180799_ab() ? this.limbSwingAmount * 4.0f : this.limbSwingAmount;
        } else {
            return super.getAnimationDegree(entity);
        }
        return Math.max(this.isMoving(entity) ? 0.5f : 0.0f, Math.min(1.0f, degree));
    }

    @Override
    protected Animation getRequestedAnimation(DinosaurEntity entity) {
        if (entity.isCarcass()) {
            return DinosaurAnimation.IDLE.get();
        }
        if (this.isMoving(entity)) {
            if (entity.isSwimming()) {
                return DinosaurAnimation.SWIMMING.get();
            }
            if (entity.isRunning()) {
                return DinosaurAnimation.RUNNING.get();
            }
            return DinosaurAnimation.WALKING.get();
        }
        return DinosaurAnimation.IDLE.get();
    }

    private boolean isMoving(DinosaurEntity entity) {
        float deltaX = (float)(entity.field_70165_t - entity.field_70169_q);
        float deltaZ = (float)(entity.field_70161_v - entity.field_70166_s);
        return deltaX * deltaX + deltaZ * deltaZ > 0.001f;
    }

    @Override
    public boolean isLooping() {
        return true;
    }
}

