/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.animation;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandResultStats;
import net.minecraft.command.EntityNotFoundException;
import net.minecraft.command.EntitySelector;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.Entity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import org.jurassicraft.JurassiCraft;
import org.jurassicraft.client.model.animation.DinosaurAnimation;
import org.jurassicraft.server.entity.DinosaurEntity;

public class ForceAnimationCommand
implements ICommand {
    private final List<String> aliases = new ArrayList<String>();

    public ForceAnimationCommand() {
        this.aliases.add("animate");
        this.aliases.add("anim");
    }

    public int compareTo(ICommand o) {
        return 0;
    }

    public String func_71517_b() {
        return "animate";
    }

    public String func_71518_a(ICommandSender parSender) {
        return "animate <AnimID> [<entitySelector>]";
    }

    public List<String> func_71514_a() {
        return this.aliases;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        World world = sender.func_130014_f_();
        if (world.field_72995_K) {
            JurassiCraft.INSTANCE.getLogger().debug("Not processing on Client side");
        } else {
            JurassiCraft.INSTANCE.getLogger().debug("Processing on Server side");
            if (args.length < 1) {
                throw new WrongUsageException("Missing the animation to set", new Object[0]);
            }
            String entitySelector = args.length < 2 ? "@e[c=1]" : args[1];
            List dinos = EntitySelector.func_179656_b((ICommandSender)new ProxySender(server, sender), (String)entitySelector, DinosaurEntity.class);
            if (dinos.size() == 0) {
                throw new EntityNotFoundException("No DinosaurEntity to animate", new Object[0]);
            }
            for (DinosaurEntity entity : dinos) {
                try {
                    entity.setAnimation(DinosaurAnimation.valueOf(args[0].toUpperCase(Locale.ENGLISH)).get());
                }
                catch (IllegalArgumentException iae) {
                    throw new CommandException(args[0] + " is not a valid animation.", new Object[0]);
                }
                sender.func_145747_a((ITextComponent)new TextComponentString("Animating entity " + entity.func_145782_y() + " with animation type " + args[0]));
            }
        }
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return true;
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
        if (args.length == 1) {
            ArrayList animations = Lists.newArrayList();
            String current = args[0].toLowerCase(Locale.ENGLISH);
            for (DinosaurAnimation animation : DinosaurAnimation.values()) {
                if (!animation.name().toLowerCase(Locale.ENGLISH).startsWith(current)) continue;
                animations.add(animation.name());
            }
            return animations;
        }
        return null;
    }

    public boolean func_82358_a(String[] var1, int var2) {
        return false;
    }

    private static class ProxySender
    implements ICommandSender {
        private final ICommandSender original;
        private MinecraftServer server;

        public ProxySender(MinecraftServer server, ICommandSender proxy) {
            this.original = Objects.requireNonNull(proxy);
            this.server = server;
        }

        public void func_145747_a(ITextComponent component) {
            this.original.func_145747_a(component);
        }

        public boolean func_70003_b(int permLevel, String commandName) {
            return commandName.equals("@") || this.original.func_70003_b(permLevel, commandName);
        }

        public Entity func_174793_f() {
            return this.original.func_174793_f();
        }

        public String func_70005_c_() {
            return this.original.func_70005_c_();
        }

        public ITextComponent func_145748_c_() {
            return this.original.func_145748_c_();
        }

        public World func_130014_f_() {
            return this.original.func_130014_f_();
        }

        public BlockPos func_180425_c() {
            return this.original.func_180425_c();
        }

        public Vec3d func_174791_d() {
            return this.original.func_174791_d();
        }

        public boolean func_174792_t_() {
            return this.original.func_174792_t_();
        }

        public void func_174794_a(CommandResultStats.Type type, int amount) {
            this.original.func_174794_a(type, amount);
        }

        public MinecraftServer func_184102_h() {
            return this.server;
        }
    }
}

