/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.block;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jurassicraft.server.block.OrientedBlock;
import org.jurassicraft.server.block.entity.ActionFigureBlockEntity;
import org.jurassicraft.server.dinosaur.Dinosaur;
import org.jurassicraft.server.entity.EntityHandler;
import org.jurassicraft.server.item.ItemHandler;

public class ActionFigureBlock
extends OrientedBlock {
    public ActionFigureBlock() {
        super(Material.field_151575_d);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_149675_a(true);
        this.func_149711_c(0.0f);
        this.func_149752_b(0.0f);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess blockAccess, BlockPos pos) {
        return this.getBounds(blockAccess, pos);
    }

    public AxisAlignedBB func_180640_a(IBlockState state, World world, BlockPos pos) {
        return this.getBounds((IBlockAccess)world, pos).func_186670_a(pos);
    }

    private AxisAlignedBB getBounds(IBlockAccess world, BlockPos pos) {
        Dinosaur dinosaur;
        TileEntity entity = world.func_175625_s(pos);
        if (entity instanceof ActionFigureBlockEntity && (dinosaur = EntityHandler.getDinosaurById(((ActionFigureBlockEntity)entity).dinosaur)) != null) {
            float width = dinosaur.getAdultSizeX() * 0.2f / 2.0f;
            float height = dinosaur.getAdultSizeY() * 0.2f;
            return new AxisAlignedBB(0.5 - (double)width, 0.0, 0.5 - (double)width, (double)width + 0.5, (double)height, (double)width + 0.5);
        }
        return new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        return super.func_176196_c(world, pos) && this.canBlockStay(world, pos);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block) {
        super.func_189540_a(state, world, pos, block);
        this.checkAndDropBlock(world, pos, world.func_180495_p(pos));
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        this.checkAndDropBlock(world, pos, state);
    }

    protected void checkAndDropBlock(World world, BlockPos pos, IBlockState state) {
        if (!this.canBlockStay(world, pos)) {
            this.func_176226_b(world, pos, state, 0);
            world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
        }
    }

    public boolean canBlockStay(World world, BlockPos pos) {
        return world.func_180495_p(pos.func_177977_b()).func_185914_p();
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return ItemHandler.ACTION_FIGURE;
    }

    @SideOnly(value=Side.CLIENT)
    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack((Item)ItemHandler.ACTION_FIGURE);
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new ActionFigureBlockEntity();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    @Override
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Override
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return true;
    }

    protected ActionFigureBlockEntity getTile(IBlockAccess world, BlockPos pos) {
        return (ActionFigureBlockEntity)world.func_175625_s(pos);
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        if (!player.field_71075_bZ.field_75098_d) {
            this.func_176226_b(world, pos, state, 0);
        }
        super.func_176208_a(world, pos, state, player);
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>(1);
        ActionFigureBlockEntity tile = this.getTile(world, pos);
        if (tile != null) {
            drops.add(new ItemStack((Item)ItemHandler.ACTION_FIGURE, 1, tile.dinosaur));
        }
        return drops;
    }
}

