/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.block.entity;

import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntityLockable;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jurassicraft.server.api.CleanableItem;
import org.jurassicraft.server.container.CleaningStationContainer;

public class CleaningStationBlockEntity
extends TileEntityLockable
implements ITickable,
ISidedInventory {
    private static final int[] slotsTop = new int[]{0};
    private static final int[] slotsBottom = new int[]{7, 6, 5, 4, 3, 2, 1};
    private static final int[] slotsSides = new int[]{1};
    private ItemStack[] slots = new ItemStack[8];
    private int cleaningStationWaterTime;
    private int currentItemWaterTime;
    private int cleanTime;
    private int totalCleanTime;
    private String customName;

    @SideOnly(value=Side.CLIENT)
    public static boolean isCleaning(IInventory inventory) {
        return inventory.func_174887_a_(0) > 0;
    }

    public static boolean isItemFuel(ItemStack stack) {
        return stack != null && stack.func_77973_b() == Items.field_151131_as;
    }

    public int func_70302_i_() {
        return this.slots.length;
    }

    public ItemStack func_70301_a(int index) {
        return this.slots[index];
    }

    public ItemStack func_70298_a(int index, int count) {
        if (this.slots[index] != null) {
            if (this.slots[index].field_77994_a <= count) {
                ItemStack stack = this.slots[index];
                this.slots[index] = null;
                return stack;
            }
            ItemStack stack = this.slots[index].func_77979_a(count);
            if (this.slots[index].field_77994_a == 0) {
                this.slots[index] = null;
            }
            return stack;
        }
        return null;
    }

    public ItemStack func_70304_b(int index) {
        if (this.slots[index] != null) {
            ItemStack stack = this.slots[index];
            this.slots[index] = null;
            return stack;
        }
        return null;
    }

    public void func_70299_a(int index, ItemStack stack) {
        boolean flag = stack != null && stack.func_77969_a(this.slots[index]) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)this.slots[index]);
        this.slots[index] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
        if (index == 0 && !flag) {
            this.totalCleanTime = this.getStackWashTime(stack);
            this.cleanTime = 0;
            this.func_70296_d();
        }
    }

    public String func_70005_c_() {
        return this.func_145818_k_() ? this.customName : "container.cleaning_station";
    }

    public boolean func_145818_k_() {
        return this.customName != null && this.customName.length() > 0;
    }

    public void setCustomInventoryName(String customName) {
        this.customName = customName;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        NBTTagList itemList = compound.func_150295_c("Items", 10);
        this.slots = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < itemList.func_74745_c(); ++i) {
            NBTTagCompound item = itemList.func_150305_b(i);
            byte slot = item.func_74771_c("Slot");
            if (slot < 0 || slot >= this.slots.length) continue;
            this.slots[slot] = ItemStack.func_77949_a((NBTTagCompound)item);
        }
        this.cleaningStationWaterTime = compound.func_74765_d("WaterTime");
        this.cleanTime = compound.func_74765_d("CleanTime");
        this.totalCleanTime = compound.func_74765_d("CleanTimeTotal");
        this.currentItemWaterTime = this.getItemCleanTime(this.slots[1]);
        if (compound.func_150297_b("CustomName", 8)) {
            this.customName = compound.func_74779_i("CustomName");
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound = super.func_189515_b(compound);
        compound.func_74777_a("WaterTime", (short)this.cleaningStationWaterTime);
        compound.func_74777_a("CleanTime", (short)this.cleanTime);
        compound.func_74777_a("CleanTimeTotal", (short)this.totalCleanTime);
        NBTTagList itemList = new NBTTagList();
        for (int slot = 0; slot < this.slots.length; ++slot) {
            if (this.slots[slot] == null) continue;
            NBTTagCompound itemTag = new NBTTagCompound();
            itemTag.func_74774_a("Slot", (byte)slot);
            this.slots[slot].func_77955_b(itemTag);
            itemList.func_74742_a((NBTBase)itemTag);
        }
        compound.func_74782_a("Items", (NBTBase)itemList);
        if (this.func_145818_k_()) {
            compound.func_74778_a("CustomName", this.customName);
        }
        return compound;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean isCleaning() {
        return this.cleaningStationWaterTime > 0;
    }

    public void func_73660_a() {
        boolean isCleaning = this.isCleaning();
        boolean sync = false;
        if (this.isCleaning() && this.canClean()) {
            --this.cleaningStationWaterTime;
        }
        if (!this.field_145850_b.field_72995_K) {
            if (!(this.isCleaning() || this.slots[1] != null && this.slots[0] != null)) {
                if (!this.isCleaning() && this.cleanTime > 0) {
                    this.cleanTime = MathHelper.func_76125_a((int)(this.cleanTime - 2), (int)0, (int)this.totalCleanTime);
                }
            } else {
                if (!this.isCleaning() && this.canClean() && CleaningStationBlockEntity.isItemFuel(this.slots[1])) {
                    this.currentItemWaterTime = this.cleaningStationWaterTime = this.getItemCleanTime(this.slots[1]);
                    if (this.isCleaning()) {
                        sync = true;
                        if (this.slots[1] != null) {
                            --this.slots[1].field_77994_a;
                            if (this.slots[1].field_77994_a == 0) {
                                this.slots[1] = this.slots[1].func_77973_b().getContainerItem(this.slots[1]);
                            }
                        }
                    }
                }
                if (this.isCleaning() && this.canClean() && this.cleaningStationWaterTime > 0) {
                    ++this.cleanTime;
                    if (this.cleanTime == this.totalCleanTime) {
                        this.cleanTime = 0;
                        this.totalCleanTime = this.getStackWashTime(this.slots[0]);
                        this.cleanItem();
                        sync = true;
                    }
                } else {
                    this.cleanTime = 0;
                    sync = true;
                }
            }
            if (isCleaning != this.isCleaning()) {
                sync = true;
            }
        }
        if (this.cleaningStationWaterTime == 0) {
            this.cleanTime = 0;
        }
        if (sync) {
            this.func_70296_d();
        }
    }

    private int getItemCleanTime(ItemStack stack) {
        return 1600;
    }

    public int getStackWashTime(ItemStack stack) {
        return 200;
    }

    private boolean canClean() {
        CleanableItem cleanableItem = CleanableItem.getCleanableItem(this.slots[0]);
        if (cleanableItem != null && cleanableItem.isCleanable(this.slots[0])) {
            for (int i = 2; i < 8; ++i) {
                if (this.slots[i] != null) continue;
                return true;
            }
        }
        return false;
    }

    public void cleanItem() {
        if (this.canClean()) {
            CleanableItem cleanableItem = CleanableItem.getCleanableItem(this.slots[0]);
            Random rand = new Random();
            ItemStack output = cleanableItem.getCleanedItem(this.slots[0], rand);
            int emptySlot = -1;
            for (int i = 2; i < 8; ++i) {
                ItemStack slot = this.slots[i];
                if (slot != null && (!ItemStack.func_179545_c((ItemStack)slot, (ItemStack)output) || !ItemStack.func_77970_a((ItemStack)slot, (ItemStack)output) || slot.func_77952_i() != output.func_77952_i())) continue;
                emptySlot = i;
                break;
            }
            if (emptySlot != -1) {
                if (this.slots[emptySlot] == null) {
                    this.slots[emptySlot] = output;
                } else if (this.slots[emptySlot].func_77973_b() == output.func_77973_b() && ItemStack.func_77970_a((ItemStack)this.slots[emptySlot], (ItemStack)output)) {
                    this.slots[emptySlot].field_77994_a += output.field_77994_a;
                }
                --this.slots[0].field_77994_a;
                if (this.slots[0].field_77994_a <= 0) {
                    this.slots[0] = null;
                }
            }
        }
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) == this && player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return index != 2 && (index != 1 || CleaningStationBlockEntity.isItemFuel(stack));
    }

    public int[] func_180463_a(EnumFacing side) {
        return side == EnumFacing.DOWN ? slotsBottom : (side == EnumFacing.UP ? slotsTop : slotsSides);
    }

    public boolean func_180462_a(int index, ItemStack stack, EnumFacing direction) {
        return this.func_94041_b(index, stack);
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        Item item;
        return direction != EnumFacing.DOWN || index != 1 || (item = stack.func_77973_b()) == Items.field_151131_as || item == Items.field_151133_ar;
    }

    public String func_174875_k() {
        return "jurassicraft:cleaning_station";
    }

    public Container func_174876_a(InventoryPlayer inventory, EntityPlayer playerIn) {
        return new CleaningStationContainer(inventory, (IInventory)this);
    }

    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.cleaningStationWaterTime;
            }
            case 1: {
                return this.currentItemWaterTime;
            }
            case 2: {
                return this.cleanTime;
            }
            case 3: {
                return this.totalCleanTime;
            }
        }
        return 0;
    }

    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.cleaningStationWaterTime = value;
                break;
            }
            case 1: {
                this.currentItemWaterTime = value;
                break;
            }
            case 2: {
                this.cleanTime = value;
                break;
            }
            case 3: {
                this.totalCleanTime = value;
            }
        }
    }

    public int func_174890_g() {
        return 4;
    }

    public void func_174888_l() {
        for (int i = 0; i < this.slots.length; ++i) {
            this.slots[i] = null;
        }
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound compound = new NBTTagCompound();
        compound = this.func_189515_b(compound);
        return new SPacketUpdateTileEntity(this.field_174879_c, this.func_145832_p(), compound);
    }

    public void onDataPacket(NetworkManager networkManager, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }
}

