/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.block.entity;

import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemBucketMilk;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import org.jurassicraft.server.block.entity.MachineBaseBlockEntity;
import org.jurassicraft.server.container.CultivateContainer;
import org.jurassicraft.server.dinosaur.Dinosaur;
import org.jurassicraft.server.entity.DinosaurEntity;
import org.jurassicraft.server.entity.EntityHandler;
import org.jurassicraft.server.food.FoodNutrients;
import org.jurassicraft.server.item.ItemHandler;

public class CultivatorBlockEntity
extends MachineBaseBlockEntity {
    private static final int[] INPUTS = new int[]{0, 1, 2, 3};
    private static final int[] OUTPUTS = new int[]{4};
    private static final int MAX_NUTRIENTS = 3000;
    private ItemStack[] slots = new ItemStack[5];
    private int waterLevel;
    private int lipids;
    private int proximates;
    private int minerals;
    private int vitamins;

    @Override
    protected int getProcess(int slot) {
        return 0;
    }

    @Override
    protected boolean canProcess(int process) {
        Dinosaur dino;
        return this.slots[0] != null && this.slots[0].func_77973_b() == ItemHandler.SYRINGE && this.waterLevel == 3 && (dino = EntityHandler.getDinosaurById(this.slots[0].func_77952_i())) != null && dino.isMammal() && this.lipids >= dino.getLipids() && this.minerals >= dino.getMinerals() && this.proximates >= dino.getProximates() && this.vitamins >= dino.getVitamins();
    }

    @Override
    protected void processItem(int process) {
        Dinosaur dinoInEgg = EntityHandler.getDinosaurById(this.slots[0].func_77952_i());
        this.waterLevel = 0;
        if (dinoInEgg != null) {
            this.lipids -= dinoInEgg.getLipids();
            this.minerals -= dinoInEgg.getMinerals();
            this.vitamins -= dinoInEgg.getVitamins();
            this.proximates -= dinoInEgg.getProximates();
            Class<? extends DinosaurEntity> dinoClass = dinoInEgg.getDinosaurClass();
            try {
                DinosaurEntity dino = dinoClass.getConstructor(World.class).newInstance(this.field_145850_b);
                dino.setDNAQuality(this.slots[0].func_77978_p().func_74762_e("DNAQuality"));
                dino.setGenetics(this.slots[0].func_77978_p().func_74779_i("Genetics"));
                int blockX = this.field_174879_c.func_177958_n();
                int blockY = this.field_174879_c.func_177956_o();
                int blockZ = this.field_174879_c.func_177952_p();
                dino.setAge(0);
                dino.func_70012_b((double)blockX + 0.5, blockY + 1, (double)blockZ + 0.5, MathHelper.func_76142_g((float)(this.field_145850_b.field_73012_v.nextFloat() * 360.0f)), 0.0f);
                dino.field_70759_as = dino.field_70177_z;
                dino.field_70761_aq = dino.field_70177_z;
                this.field_145850_b.func_72838_d((Entity)dino);
                --this.slots[0].field_77994_a;
                if (this.slots[0].field_77994_a <= 0) {
                    this.slots[0] = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        boolean sync = false;
        if (!this.field_145850_b.field_72995_K) {
            if (this.waterLevel < 3 && this.slots[2] != null && this.slots[2].func_77973_b() == Items.field_151131_as && (this.slots[3] == null || this.slots[3].field_77994_a < 16)) {
                --this.slots[2].field_77994_a;
                if (this.slots[2].field_77994_a <= 0) {
                    this.slots[2] = null;
                }
                ++this.waterLevel;
                if (this.slots[3] == null) {
                    this.slots[3] = new ItemStack(Items.field_151133_ar);
                } else if (this.slots[3].func_77973_b() == Items.field_151133_ar) {
                    ++this.slots[3].field_77994_a;
                }
                sync = true;
            }
            if (this.slots[1] != null && FoodNutrients.FOOD_LIST.containsKey(this.slots[1].func_77973_b()) && (this.proximates < 3000 || this.minerals < 3000 || this.vitamins < 3000 || this.lipids < 3000)) {
                this.consumeNutrients();
                sync = true;
            }
        }
        if (sync) {
            this.func_70296_d();
        }
    }

    private void consumeNutrients() {
        FoodNutrients nutrients = FoodNutrients.values()[FoodNutrients.FOOD_LIST.get(this.slots[1].func_77973_b())];
        if (this.slots[1].func_77973_b() instanceof ItemBucketMilk) {
            this.slots[1] = null;
            this.slots[1] = new ItemStack(Items.field_151133_ar);
        } else {
            --this.slots[1].field_77994_a;
            if (this.slots[1].field_77994_a <= 0) {
                this.slots[1] = null;
            }
        }
        Random random = new Random();
        if (this.proximates < 3000) {
            this.proximates = (short)((double)this.proximates + (double)(800 + random.nextInt(201)) * nutrients.getProximate());
            if (this.proximates > 3000) {
                this.proximates = 3000;
            }
        }
        if (this.minerals < 3000) {
            this.minerals = (short)((double)this.minerals + (double)(900 + random.nextInt(101)) * nutrients.getMinerals());
            if (this.minerals > 3000) {
                this.minerals = 3000;
            }
        }
        if (this.vitamins < 3000) {
            this.vitamins = (short)((double)this.vitamins + (double)(900 + random.nextInt(101)) * nutrients.getVitamins());
            if (this.vitamins > 3000) {
                this.vitamins = 3000;
            }
        }
        if (this.lipids < 3000) {
            this.lipids = (short)((double)this.lipids + (double)(980 + random.nextInt(101)) * nutrients.getLipids());
            if (this.lipids > 3000) {
                this.lipids = 3000;
            }
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.waterLevel = compound.func_74765_d("WaterLevel");
        this.lipids = compound.func_74762_e("Lipids");
        this.minerals = compound.func_74762_e("Minerals");
        this.vitamins = compound.func_74762_e("Vitamins");
        this.proximates = compound.func_74762_e("Proximates");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound = super.func_189515_b(compound);
        compound.func_74777_a("WaterLevel", (short)this.waterLevel);
        compound.func_74768_a("Lipids", this.lipids);
        compound.func_74768_a("Minerals", this.minerals);
        compound.func_74768_a("Vitamins", this.vitamins);
        compound.func_74768_a("Proximates", this.proximates);
        return compound;
    }

    @Override
    protected int getMainOutput(int process) {
        return 4;
    }

    @Override
    protected int getStackProcessTime(ItemStack stack) {
        return 2000;
    }

    @Override
    protected int getProcessCount() {
        return 1;
    }

    @Override
    protected int[] getInputs() {
        return INPUTS;
    }

    @Override
    protected int[] getInputs(int process) {
        return INPUTS;
    }

    @Override
    protected int[] getOutputs() {
        return OUTPUTS;
    }

    @Override
    protected ItemStack[] getSlots() {
        return this.slots;
    }

    @Override
    protected void setSlots(ItemStack[] slots) {
        this.slots = slots;
    }

    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        return new CultivateContainer(playerInventory, (TileEntity)this);
    }

    public String func_174875_k() {
        return "jurassicraft:cultivator";
    }

    public String func_70005_c_() {
        return this.func_145818_k_() ? this.customName : "container.cultivator";
    }

    public int getWaterLevel() {
        return this.waterLevel;
    }

    public int getMaxNutrients() {
        return 3000;
    }

    public int getProximates() {
        return this.proximates;
    }

    public int getMinerals() {
        return this.minerals;
    }

    public int getVitamins() {
        return this.vitamins;
    }

    public int getLipids() {
        return this.lipids;
    }

    @Override
    public int func_174887_a_(int id) {
        int processCount = this.getProcessCount();
        if (id < processCount) {
            return this.processTime[id];
        }
        if (id < processCount * 2) {
            return this.totalProcessTime[id - processCount];
        }
        int type = id - processCount * 2;
        switch (type) {
            case 0: {
                return this.waterLevel;
            }
            case 1: {
                return this.proximates;
            }
            case 2: {
                return this.minerals;
            }
            case 3: {
                return this.vitamins;
            }
            case 4: {
                return this.lipids;
            }
        }
        return 0;
    }

    @Override
    public void func_174885_b(int id, int value) {
        int processCount = this.getProcessCount();
        if (id < processCount) {
            this.processTime[id] = value;
        } else if (id < processCount * 2) {
            this.totalProcessTime[id - processCount] = value;
        } else {
            int type = id - processCount * 2;
            switch (type) {
                case 0: {
                    this.waterLevel = value;
                    break;
                }
                case 1: {
                    this.proximates = value;
                    break;
                }
                case 2: {
                    this.minerals = value;
                    break;
                }
                case 3: {
                    this.vitamins = value;
                    break;
                }
                case 4: {
                    this.lipids = value;
                }
            }
        }
    }

    @Override
    public int func_174890_g() {
        return this.getProcessCount() * 2 + 5;
    }

    public Dinosaur getDinosaur() {
        if (this.slots[0] != null) {
            return EntityHandler.getDinosaurById(this.slots[0].func_77952_i());
        }
        return null;
    }
}

