/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.block.entity;

import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import org.jurassicraft.server.api.SequencableItem;
import org.jurassicraft.server.block.entity.MachineBaseBlockEntity;
import org.jurassicraft.server.container.DNASequencerContainer;
import org.jurassicraft.server.item.ItemHandler;

public class DNASequencerBlockEntity
extends MachineBaseBlockEntity {
    private static final int[] INPUTS = new int[]{0, 1, 2, 3, 4, 5};
    private static final int[] INPUTS_PROCESS_1 = new int[]{0, 1};
    private static final int[] INPUTS_PROCESS_2 = new int[]{2, 3};
    private static final int[] INPUTS_PROCESS_3 = new int[]{4, 5};
    private static final int[] OUTPUTS = new int[]{6, 7, 8};
    private ItemStack[] slots = new ItemStack[9];

    @Override
    protected int getProcess(int slot) {
        return Math.min(5, (int)Math.floor(slot / 2));
    }

    @Override
    protected boolean canProcess(int process) {
        int tissue = process * 2;
        ItemStack input = this.slots[tissue];
        ItemStack storage = this.slots[tissue + 1];
        SequencableItem sequencableItem = SequencableItem.getSequencableItem(input);
        return sequencableItem != null && sequencableItem.isSequencable(input) && storage != null && storage.func_77973_b() == ItemHandler.STORAGE_DISC && this.slots[process + 6] == null;
    }

    @Override
    protected void processItem(int process) {
        Random rand = new Random();
        int tissue = process * 2;
        ItemStack sequencableStack = this.slots[tissue];
        this.mergeStack(process + 6, SequencableItem.getSequencableItem(sequencableStack).getSequenceOutput(sequencableStack, rand));
        this.decreaseStackSize(tissue);
        this.decreaseStackSize(tissue + 1);
    }

    @Override
    protected int getMainOutput(int process) {
        return process * 2 + 1;
    }

    @Override
    protected int getStackProcessTime(ItemStack stack) {
        return 2000;
    }

    @Override
    protected int getProcessCount() {
        return 3;
    }

    @Override
    protected int[] getInputs() {
        return INPUTS;
    }

    @Override
    protected int[] getInputs(int process) {
        if (process == 0) {
            return INPUTS_PROCESS_1;
        }
        if (process == 1) {
            return INPUTS_PROCESS_2;
        }
        return INPUTS_PROCESS_3;
    }

    @Override
    protected int[] getOutputs() {
        return OUTPUTS;
    }

    @Override
    protected ItemStack[] getSlots() {
        return this.slots;
    }

    @Override
    protected void setSlots(ItemStack[] slots) {
        this.slots = slots;
    }

    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        return new DNASequencerContainer(playerInventory, (TileEntity)this);
    }

    public String func_174875_k() {
        return "jurassicraft:dna_sequencer";
    }

    public String func_70005_c_() {
        return this.func_145818_k_() ? this.customName : "container.dna_sequencer";
    }
}

