/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.block.entity;

import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import org.jurassicraft.server.api.GrindableItem;
import org.jurassicraft.server.block.entity.MachineBaseBlockEntity;
import org.jurassicraft.server.container.FossilGrinderContainer;

public class FossilGrinderBlockEntity
extends MachineBaseBlockEntity {
    private static final int[] INPUTS = new int[]{0, 1, 2, 3, 4, 5};
    private static final int[] OUTPUTS = new int[]{6, 7, 8, 9, 10, 11};
    private ItemStack[] slots = new ItemStack[12];

    @Override
    protected int getProcess(int slot) {
        return 0;
    }

    @Override
    protected boolean canProcess(int process) {
        for (int inputIndex = 0; inputIndex < 6; ++inputIndex) {
            ItemStack input = this.slots[inputIndex];
            GrindableItem grindableItem = GrindableItem.getGrindableItem(input);
            if (grindableItem == null || !grindableItem.isGrindable(input)) continue;
            for (int outputIndex = 6; outputIndex < 12; ++outputIndex) {
                if (this.slots[outputIndex] != null) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected void processItem(int process) {
        GrindableItem grindableItem;
        ItemStack output;
        int emptySlot;
        Random rand = new Random();
        ItemStack input = null;
        int index = 0;
        for (int inputIndex = 0; inputIndex < 6; ++inputIndex) {
            input = this.slots[inputIndex];
            if (input == null) continue;
            index = inputIndex;
            break;
        }
        if (input != null && (emptySlot = this.getOutputSlot(output = (grindableItem = GrindableItem.getGrindableItem(input)).getGroundItem(input, rand))) != -1) {
            this.mergeStack(emptySlot, output);
            this.decreaseStackSize(index);
        }
    }

    @Override
    protected int getMainOutput(int process) {
        return 1;
    }

    @Override
    protected int getStackProcessTime(ItemStack stack) {
        return 200;
    }

    @Override
    protected int getProcessCount() {
        return 1;
    }

    @Override
    protected int[] getInputs() {
        return INPUTS;
    }

    @Override
    protected int[] getInputs(int process) {
        return this.getInputs();
    }

    @Override
    protected int[] getOutputs() {
        return OUTPUTS;
    }

    @Override
    protected ItemStack[] getSlots() {
        return this.slots;
    }

    @Override
    protected void setSlots(ItemStack[] slots) {
        this.slots = slots;
    }

    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        return new FossilGrinderContainer(playerInventory, (TileEntity)this);
    }

    public String func_174875_k() {
        return "jurassicraft:fossil_grinder";
    }

    public String func_70005_c_() {
        return this.func_145818_k_() ? this.customName : "container.fossil_grinder";
    }
}

