/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.block.entity;

import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import org.jurassicraft.server.api.IncubatorEnvironmentItem;
import org.jurassicraft.server.block.entity.MachineBaseBlockEntity;
import org.jurassicraft.server.container.IncubatorContainer;
import org.jurassicraft.server.item.DinosaurEggItem;
import org.jurassicraft.server.item.ItemHandler;

public class IncubatorBlockEntity
extends MachineBaseBlockEntity {
    private static final int[] INPUTS = new int[]{0, 1, 2, 3, 4};
    private static final int[] ENVIRONMENT = new int[]{5};
    private int[] temperature = new int[5];
    private ItemStack[] slots = new ItemStack[6];

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        for (int i = 0; i < this.getProcessCount(); ++i) {
            this.temperature[i] = compound.func_74765_d("Temperature" + i);
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound = super.func_189515_b(compound);
        for (int i = 0; i < this.getProcessCount(); ++i) {
            compound.func_74777_a("Temperature" + i, (short)this.temperature[i]);
        }
        return compound;
    }

    @Override
    protected int getProcess(int slot) {
        if (slot == 5) {
            return -1;
        }
        return slot;
    }

    @Override
    protected boolean canProcess(int process) {
        Item item;
        ItemStack environment = this.slots[5];
        boolean hasEnvironment = false;
        if (environment != null && ((item = environment.func_77973_b()) instanceof IncubatorEnvironmentItem || Block.func_149634_a((Item)item) instanceof IncubatorEnvironmentItem)) {
            hasEnvironment = true;
        }
        return hasEnvironment && this.slots[process] != null && this.slots[process].field_77994_a > 0 && this.slots[process].func_77973_b() instanceof DinosaurEggItem;
    }

    @Override
    protected void processItem(int process) {
        if (this.canProcess(process) && !this.field_145850_b.field_72995_K) {
            ItemStack egg = this.slots[process];
            ItemStack incubatedEgg = new ItemStack((Item)ItemHandler.HATCHED_EGG, 1, egg.func_77952_i());
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74757_a("Gender", this.temperature[process] > 50);
            if (egg.func_77978_p() != null) {
                compound.func_74778_a("Genetics", egg.func_77978_p().func_74779_i("Genetics"));
                compound.func_74768_a("DNAQuality", egg.func_77978_p().func_74762_e("DNAQuality"));
            }
            incubatedEgg.func_77982_d(compound);
            this.decreaseStackSize(5);
            this.slots[process] = incubatedEgg;
        }
    }

    @Override
    protected int getMainOutput(int process) {
        return 0;
    }

    @Override
    protected int getStackProcessTime(ItemStack stack) {
        return 8000;
    }

    @Override
    protected int getProcessCount() {
        return 5;
    }

    @Override
    protected int[] getInputs() {
        return INPUTS;
    }

    @Override
    protected int[] getInputs(int process) {
        return new int[]{process};
    }

    @Override
    protected int[] getOutputs() {
        return ENVIRONMENT;
    }

    @Override
    protected ItemStack[] getSlots() {
        return this.slots;
    }

    @Override
    protected void setSlots(ItemStack[] slots) {
        this.slots = slots;
    }

    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        return new IncubatorContainer(playerInventory, (TileEntity)this);
    }

    public String func_174875_k() {
        return "jurassicraft:incubator";
    }

    public String func_70005_c_() {
        return this.func_145818_k_() ? this.customName : "container.incubator";
    }

    @Override
    public int func_174887_a_(int id) {
        if (id < 5) {
            return this.processTime[id];
        }
        if (id < 10) {
            return this.totalProcessTime[id - 5];
        }
        if (id < 15) {
            return this.temperature[id - 10];
        }
        return 0;
    }

    @Override
    public void func_174885_b(int id, int value) {
        if (id < 5) {
            this.processTime[id] = value;
        } else if (id < 10) {
            this.totalProcessTime[id - 5] = value;
        } else if (id < 15) {
            this.temperature[id - 10] = value;
        }
    }

    @Override
    protected boolean shouldResetProgress() {
        return false;
    }
}

