/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.block.entity;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntityLockable;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class MachineBaseBlockEntity
extends TileEntityLockable
implements ITickable,
ISidedInventory {
    protected String customName;
    protected int[] processTime = new int[this.getProcessCount()];
    protected int[] totalProcessTime = new int[this.getProcessCount()];

    @SideOnly(value=Side.CLIENT)
    public static boolean isProcessing(IInventory inventory, int index) {
        return inventory.func_174887_a_(index) > 0;
    }

    public void func_145839_a(NBTTagCompound compound) {
        int i;
        super.func_145839_a(compound);
        NBTTagList itemList = compound.func_150295_c("Items", 10);
        ItemStack[] slots = new ItemStack[this.getSlots().length];
        for (i = 0; i < itemList.func_74745_c(); ++i) {
            NBTTagCompound item = itemList.func_150305_b(i);
            byte slot = item.func_74771_c("Slot");
            if (slot < 0 || slot >= slots.length) continue;
            slots[slot] = ItemStack.func_77949_a((NBTTagCompound)item);
        }
        for (i = 0; i < this.getProcessCount(); ++i) {
            this.processTime[i] = compound.func_74765_d("ProcessTime" + i);
            this.totalProcessTime[i] = compound.func_74765_d("ProcessTimeTotal" + i);
        }
        if (compound.func_150297_b("CustomName", 8)) {
            this.customName = compound.func_74779_i("CustomName");
        }
        this.setSlots(slots);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound = super.func_189515_b(compound);
        for (int i = 0; i < this.getProcessCount(); ++i) {
            compound.func_74777_a("ProcessTime" + i, (short)this.processTime[i]);
            compound.func_74777_a("ProcessTimeTotal" + i, (short)this.totalProcessTime[i]);
        }
        ItemStack[] slots = this.getSlots();
        NBTTagList itemList = new NBTTagList();
        for (int slot = 0; slot < this.func_70302_i_(); ++slot) {
            if (slots[slot] == null) continue;
            NBTTagCompound itemTag = new NBTTagCompound();
            itemTag.func_74774_a("Slot", (byte)slot);
            slots[slot].func_77955_b(itemTag);
            itemList.func_74742_a((NBTBase)itemTag);
        }
        compound.func_74782_a("Items", (NBTBase)itemList);
        if (this.func_145818_k_()) {
            compound.func_74778_a("CustomName", this.customName);
        }
        return compound;
    }

    public ItemStack func_70301_a(int index) {
        return this.getSlots()[index];
    }

    public ItemStack func_70298_a(int index, int count) {
        ItemStack[] slots = this.getSlots();
        if (slots[index] != null) {
            if (slots[index].field_77994_a <= count) {
                ItemStack stack = slots[index];
                slots[index] = null;
                return stack;
            }
            ItemStack stack = slots[index].func_77979_a(count);
            if (slots[index].field_77994_a == 0) {
                slots[index] = null;
            }
            return stack;
        }
        return null;
    }

    public ItemStack func_70304_b(int index) {
        ItemStack[] slots = this.getSlots();
        if (slots[index] != null) {
            ItemStack slot = slots[index];
            slots[index] = null;
            return slot;
        }
        return null;
    }

    public void func_70299_a(int index, ItemStack stack) {
        int process;
        ItemStack[] slots = this.getSlots();
        boolean stacksEqual = stack != null && stack.func_77969_a(slots[index]) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)slots[index]);
        slots[index] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
        if (!stacksEqual && (process = this.getProcess(index)) >= 0 && process < this.getProcessCount()) {
            this.totalProcessTime[process] = this.getStackProcessTime(stack);
            if (!this.canProcess(process)) {
                this.processTime[process] = 0;
            }
            this.func_70296_d();
        }
    }

    private boolean isInput(int slot) {
        int[] inputs;
        for (int input : inputs = this.getInputs()) {
            if (input != slot) continue;
            return true;
        }
        return false;
    }

    private boolean isOutput(int slot) {
        int[] outputs;
        for (int output : outputs = this.getOutputs()) {
            if (output != slot) continue;
            return true;
        }
        return false;
    }

    public boolean func_145818_k_() {
        return this.customName != null && this.customName.length() > 0;
    }

    public void setCustomInventoryName(String customName) {
        this.customName = customName;
    }

    public int func_70302_i_() {
        return this.getSlots().length;
    }

    public boolean isProcessing(int index) {
        return this.processTime[index] > 0;
    }

    public void func_73660_a() {
        ItemStack[] slots = this.getSlots();
        for (int process = 0; process < this.getProcessCount(); ++process) {
            boolean flag = this.isProcessing(process);
            boolean sync = false;
            if (this.field_145850_b.field_72995_K) continue;
            boolean hasInput = false;
            for (int input : this.getInputs(process)) {
                if (slots[input] == null) continue;
                hasInput = true;
                break;
            }
            if (hasInput && this.canProcess(process)) {
                int n = process;
                this.processTime[n] = this.processTime[n] + 1;
                if (this.processTime[process] >= this.totalProcessTime[process]) {
                    this.processTime[process] = 0;
                    this.totalProcessTime[process] = this.getStackProcessTime(slots[this.getInputs()[0]]);
                    this.processItem(process);
                }
                sync = true;
            } else if (this.isProcessing(process)) {
                if (this.shouldResetProgress()) {
                    this.processTime[process] = 0;
                } else if (this.processTime[process] > 0) {
                    int n = process;
                    this.processTime[n] = this.processTime[n] - 1;
                }
                sync = true;
            }
            if (flag != this.isProcessing(process)) {
                sync = true;
            }
            if (!sync) continue;
            this.func_70296_d();
        }
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) == this && player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return !this.isOutput(index);
    }

    public int[] func_180463_a(EnumFacing side) {
        return side == EnumFacing.DOWN ? this.getOutputs() : this.getInputs();
    }

    public boolean func_180462_a(int index, ItemStack stack, EnumFacing direction) {
        return this.func_94041_b(index, stack);
    }

    protected abstract int getProcess(int var1);

    protected abstract boolean canProcess(int var1);

    protected abstract void processItem(int var1);

    protected abstract int getMainOutput(int var1);

    protected abstract int getStackProcessTime(ItemStack var1);

    protected abstract int getProcessCount();

    protected abstract int[] getInputs();

    protected abstract int[] getInputs(int var1);

    protected abstract int[] getOutputs();

    protected abstract ItemStack[] getSlots();

    protected abstract void setSlots(ItemStack[] var1);

    public boolean hasOutputSlot(ItemStack output) {
        return this.getOutputSlot(output) != -1;
    }

    public int getOutputSlot(ItemStack output) {
        int[] outputs;
        ItemStack[] slots = this.getSlots();
        for (int slot : outputs = this.getOutputs()) {
            ItemStack stack = slots[slot];
            if (stack != null && (!ItemStack.func_77970_a((ItemStack)stack, (ItemStack)output) || stack.field_77994_a + output.field_77994_a > stack.func_77976_d() || stack.func_77973_b() != output.func_77973_b() || stack.func_77952_i() != output.func_77952_i())) continue;
            return slot;
        }
        return -1;
    }

    public int func_174887_a_(int id) {
        int processCount = this.getProcessCount();
        if (id < processCount) {
            return this.processTime[id];
        }
        if (id < processCount * 2) {
            return this.totalProcessTime[id - processCount];
        }
        return 0;
    }

    public void func_174885_b(int id, int value) {
        int processCount = this.getProcessCount();
        if (id < processCount) {
            this.processTime[id] = value;
        } else if (id < processCount * 2) {
            this.totalProcessTime[id - processCount] = value;
        }
    }

    public int func_174890_g() {
        return this.getProcessCount() * 2;
    }

    public void func_174888_l() {
        ItemStack[] slots = this.getSlots();
        for (int i = 0; i < slots.length; ++i) {
            slots[i] = null;
        }
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return true;
    }

    protected void mergeStack(int slot, ItemStack stack) {
        ItemStack[] slots = this.getSlots();
        if (slots[slot] == null) {
            slots[slot] = stack;
        } else if (slots[slot].func_77973_b() == stack.func_77973_b() && ItemStack.func_77970_a((ItemStack)slots[slot], (ItemStack)stack)) {
            slots[slot].field_77994_a += stack.field_77994_a;
        }
    }

    protected void decreaseStackSize(int slot) {
        ItemStack[] slots = this.getSlots();
        --slots[slot].field_77994_a;
        if (slots[slot].field_77994_a <= 0) {
            slots[slot] = null;
        }
    }

    public int func_70297_j_() {
        return 64;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void onDataPacket(NetworkManager networkManager, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    protected boolean shouldResetProgress() {
        return true;
    }
}

