/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.block.plant;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jurassicraft.server.block.PeatBlock;
import org.jurassicraft.server.tab.TabHandler;

public class MossBlock
extends Block {
    private static final AxisAlignedBB BOUNDS = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.0625, 1.0);
    private static final int DENSITY_PER_AREA = 8;
    private static final int SPREAD_RADIUS = 3;

    public MossBlock() {
        super(Material.field_151584_j);
        this.func_149711_c(0.2f);
        this.func_149752_b(0.0f);
        this.func_149675_a(true);
        this.func_149647_a(TabHandler.PLANTS);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_149713_g(0);
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (world.func_180495_p(pos.func_177977_b()).func_177230_c() instanceof PeatBlock && rand.nextInt(8) <= 3) {
            int allowedInArea = 8;
            BlockPos nextPos = null;
            for (int placementAttempts = 3; nextPos == null && placementAttempts > 0; --placementAttempts) {
                int doubleRadius = 6;
                BlockPos tmp = pos.func_177982_a(rand.nextInt(doubleRadius) - 3, -3, rand.nextInt(doubleRadius) - 3);
                nextPos = this.findGround(world, tmp);
            }
            if (nextPos != null) {
                for (BlockPos neighbourPos : BlockPos.func_177975_b((BlockPos)nextPos.func_177982_a(-2, -3, -2), (BlockPos)nextPos.func_177982_a(2, 3, 2))) {
                    if (world.func_180495_p(neighbourPos).func_177230_c() != this || --allowedInArea > 0) continue;
                    return;
                }
                world.func_175656_a(nextPos, this.func_176223_P());
            }
        }
    }

    private BlockPos findGround(World world, BlockPos start) {
        BlockPos pos = start;
        Block down = world.func_180495_p(pos.func_177977_b()).func_177230_c();
        Block here = world.func_180495_p(pos).func_177230_c();
        Block up = world.func_180495_p(pos.func_177984_a()).func_177230_c();
        for (int i = 0; i < 8; ++i) {
            if (down instanceof PeatBlock) {
                return pos;
            }
            down = here;
            here = up;
            pos = pos.func_177984_a();
            up = world.func_180495_p(pos.func_177984_a()).func_177230_c();
        }
        return null;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess blockAccess, BlockPos pos) {
        return BOUNDS;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        IBlockState below = world.func_180495_p(pos.func_177977_b());
        return super.func_176196_c(world, pos) && this.canBlockStay(world, pos) && below.func_185917_h();
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block) {
        super.func_189540_a(state, world, pos, block);
        this.checkForDrop(world, pos, state);
    }

    private boolean checkForDrop(World world, BlockPos pos, IBlockState state) {
        if (!this.canBlockStay(world, pos)) {
            this.func_176226_b(world, pos, state, 0);
            world.func_175698_g(pos);
            return false;
        }
        return true;
    }

    private boolean canBlockStay(World world, BlockPos pos) {
        return !world.func_175623_d(pos.func_177977_b());
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return side == EnumFacing.UP || super.func_176225_a(state, world, pos, side);
    }
}

