/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.entity;

public enum SleepingSchedule {
    DIURNAL(SleepingSchedule.fromTimeToTicks(6, 0), SleepingSchedule.fromTimeToTicks(22, 0)),
    NOCTURNAL(SleepingSchedule.fromTimeToTicks(18, 0), SleepingSchedule.fromTimeToTicks(6, 0)),
    CREPUSCULAR(SleepingSchedule.fromTimeToTicks(12, 30), SleepingSchedule.fromTimeToTicks(4, 30));

    private int wakeUpTime;
    private int sleepTime;

    private SleepingSchedule(int wakeUpTime, int sleepTime) {
        this.wakeUpTime = wakeUpTime;
        this.sleepTime = sleepTime;
    }

    public static int fromTimeToTicks(int hour, int minute) {
        int ticksPerMinute = 16;
        return (hour - 6) * 1000 + minute * ticksPerMinute;
    }

    public int getWakeUpTime() {
        return this.wakeUpTime;
    }

    public int getSleepTime() {
        return this.sleepTime;
    }

    public boolean sleepNextDay() {
        return this.wakeUpTime > this.sleepTime;
    }

    public int getAwakeTime() {
        int newSleepTime = this.sleepTime;
        if (this.sleepNextDay()) {
            newSleepTime += 24000;
        }
        return newSleepTime - this.wakeUpTime;
    }
}

