/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.entity.ai;

import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.init.Blocks;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jurassicraft.server.entity.DinosaurEntity;

public class SleepEntityAI
extends EntityAIBase {
    protected DinosaurEntity dinosaur;
    protected Path path;
    protected int giveUpTime;

    public SleepEntityAI(DinosaurEntity dinosaur) {
        this.dinosaur = dinosaur;
    }

    public boolean func_75250_a() {
        World world = this.dinosaur.field_70170_p;
        if ((this.dinosaur.field_70122_E || this.dinosaur.func_184218_aH()) && !this.dinosaur.field_70128_L && !world.field_72995_K && this.dinosaur.shouldSleep() && !this.dinosaur.isSleeping() && this.dinosaur.getStayAwakeTime() <= 0) {
            int range = 8;
            int posX = (int)this.dinosaur.field_70165_t;
            int posZ = (int)this.dinosaur.field_70161_v;
            for (int x = posX - range; x < posX + range; ++x) {
                for (int z = posZ - range; z < posZ + range; ++z) {
                    BlockPos possiblePos = world.func_175672_r(new BlockPos(x, 0, z));
                    if (!world.func_175623_d(possiblePos) || world.func_180495_p(possiblePos.func_177982_a(0, -1, 0)).func_177230_c() == Blocks.field_150355_j || !this.canFit(possiblePos) || world.func_175678_i(possiblePos) || !this.dinosaur.setSleepLocation(possiblePos, true)) continue;
                    this.path = this.dinosaur.func_70661_as().func_75505_d();
                    return true;
                }
            }
            return true;
        }
        return false;
    }

    private boolean canFit(BlockPos pos) {
        double z;
        double y;
        double x = (double)pos.func_177958_n() + 0.5;
        AxisAlignedBB boundingBox = new AxisAlignedBB(x, y = (double)pos.func_177956_o(), z = (double)pos.func_177952_p() + 0.5, x + (double)this.dinosaur.field_70130_N, y + (double)this.dinosaur.field_70131_O, z + (double)this.dinosaur.field_70130_N);
        return this.dinosaur.field_70170_p.func_184144_a((Entity)this.dinosaur, boundingBox).isEmpty() && this.dinosaur.field_70170_p.func_72839_b((Entity)this.dinosaur, boundingBox).isEmpty();
    }

    public void func_75249_e() {
        this.giveUpTime = 400;
    }

    public void func_75246_d() {
        Path currentPath = this.dinosaur.func_70661_as().func_75505_d();
        if (this.path != null) {
            PathPoint finalPathPoint = this.path.func_75870_c();
            if (currentPath == null || !currentPath.func_75870_c().equals((Object)finalPathPoint)) {
                Path path = this.dinosaur.func_70661_as().func_75488_a((double)finalPathPoint.field_75839_a, (double)finalPathPoint.field_75837_b, (double)finalPathPoint.field_75838_c);
                this.dinosaur.func_70661_as().func_75484_a(path, 1.0);
                this.path = path;
            }
        }
        if (this.giveUpTime <= 0 || this.dinosaur.getStayAwakeTime() <= 0 && (this.path == null || this.path.func_75879_b())) {
            this.dinosaur.setSleeping(true);
        }
        --this.giveUpTime;
    }

    public boolean func_75253_b() {
        return this.dinosaur != null && !this.dinosaur.isCarcass() && !this.dinosaur.isSleeping() && this.dinosaur.shouldSleep();
    }

    public void func_75251_c() {
        this.dinosaur.setSleeping(true);
    }
}

