/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.entity.dinosaur;

import net.ilexiconn.llibrary.server.animation.Animation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import org.jurassicraft.client.model.animation.DinosaurAnimation;
import org.jurassicraft.client.sound.SoundHandler;
import org.jurassicraft.server.entity.DinosaurEntity;
import org.jurassicraft.server.entity.VenomEntity;
import org.jurassicraft.server.entity.ai.DilophosaurusMeleeEntityAI;
import org.jurassicraft.server.entity.ai.DilophosaurusSpitEntityAI;
import org.jurassicraft.server.entity.dinosaur.GallimimusEntity;
import org.jurassicraft.server.entity.dinosaur.ParasaurolophusEntity;
import org.jurassicraft.server.entity.dinosaur.TriceratopsEntity;
import org.jurassicraft.server.entity.dinosaur.VelociraptorEntity;

public class DilophosaurusEntity
extends DinosaurEntity
implements IRangedAttackMob {
    private static final DataParameter<Boolean> WATCHER_HAS_TARGET = EntityDataManager.func_187226_a(DinosaurEntity.class, (DataSerializer)DataSerializers.field_187198_h);
    private int targetCooldown;

    public DilophosaurusEntity(World world) {
        super(world);
        this.target(EntityPlayer.class, EntityVillager.class, EntityAnimal.class, GallimimusEntity.class, ParasaurolophusEntity.class, TriceratopsEntity.class, VelociraptorEntity.class);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new DilophosaurusMeleeEntityAI(this, this.dinosaur.getAttackSpeed()));
    }

    public void func_82196_d(EntityLivingBase target, float distance) {
        VenomEntity venom = new VenomEntity(this.field_70170_p, this);
        double deltaX = target.field_70165_t - venom.field_70165_t;
        double deltaY = target.field_70163_u + (double)target.func_70047_e() - (double)1.1f - venom.field_70163_u;
        double deltaZ = target.field_70161_v - venom.field_70161_v;
        float yOffset = MathHelper.func_76133_a((double)(deltaX * deltaX + deltaZ * deltaZ)) * 0.2f;
        venom.func_70186_c(deltaX, deltaY + (double)yOffset, deltaZ, 1.5f, 0.0f);
        this.field_70170_p.func_72838_d((Entity)venom);
    }

    @Override
    public EntityAIBase getAttackAI() {
        return new DilophosaurusSpitEntityAI(this, this.dinosaur.getAttackSpeed(), 40, 10.0f);
    }

    @Override
    public void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(WATCHER_HAS_TARGET, (Object)false);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            if (this.func_70638_az() != null && this.targetCooldown < 50) {
                this.targetCooldown = 50 + this.func_70681_au().nextInt(30);
            } else if (this.targetCooldown > 0) {
                --this.targetCooldown;
            }
            this.field_70180_af.func_187227_b(WATCHER_HAS_TARGET, (Object)this.hasTarget());
        }
    }

    @Override
    public boolean func_70652_k(Entity entity) {
        if (super.func_70652_k(entity)) {
            if (entity instanceof EntityLivingBase) {
                ((EntityLivingBase)entity).func_70690_d(new PotionEffect(Potion.func_180142_b((String)"poison"), 300, 1, false, false));
            }
            return true;
        }
        return false;
    }

    public boolean hasTarget() {
        return (this.field_70170_p.field_72995_K ? (Boolean)this.field_70180_af.func_187225_a(WATCHER_HAS_TARGET) != false : this.func_70638_az() != null || this.targetCooldown > 0) && !this.isCarcass() && !this.isSleeping();
    }

    @Override
    public SoundEvent getSoundForAnimation(Animation animation) {
        switch (DinosaurAnimation.getAnimation(animation)) {
            case SPEAK: {
                return SoundHandler.DILOPHOSAURUS_LIVING;
            }
            case CALLING: {
                return SoundHandler.DILOPHOSAURUS_LIVING;
            }
            case DYING: {
                return SoundHandler.DILOPHOSAURUS_DEATH;
            }
            case INJURED: {
                return SoundHandler.DILOPHOSAURUS_HURT;
            }
        }
        return null;
    }
}

