/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.entity.vehicle;

import io.netty.buffer.ByteBuf;
import java.util.Locale;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jurassicraft.JurassiCraft;
import org.jurassicraft.server.entity.vehicle.modules.HelicopterDoor;
import org.jurassicraft.server.entity.vehicle.modules.HelicopterModule;
import org.jurassicraft.server.entity.vehicle.modules.HelicopterModuleSpot;
import org.jurassicraft.server.entity.vehicle.modules.HelicopterSeatEntity;
import org.jurassicraft.server.entity.vehicle.modules.ModulePosition;
import org.jurassicraft.server.item.vehicles.HelicopterModuleItem;
import org.jurassicraft.server.message.HelicopterDirectionMessage;
import org.jurassicraft.server.message.HelicopterEngineMessage;
import org.jurassicraft.server.message.HelicopterModulesMessage;
import org.jurassicraft.server.util.Easings;
import org.jurassicraft.server.util.MutableVec3;

public class HelicopterBaseEntity
extends EntityLivingBase
implements IEntityAdditionalSpawnData {
    public static final int FRONT = ModulePosition.FRONT.ordinal();
    public static final int LEFT_SIDE = ModulePosition.LEFT_SIDE.ordinal();
    public static final int RIGHT_SIDE = ModulePosition.RIGHT_SIDE.ordinal();
    public static final float MAX_POWER = 80.0f;
    public static final float REQUIRED_POWER = 40.0f;
    private static final DataParameter<Boolean> DATA_WATCHER_ENGINE_RUNNING = EntityDataManager.func_187226_a(HelicopterBaseEntity.class, (DataSerializer)DataSerializers.field_187198_h);
    private final HelicopterModuleSpot[] moduleSpots;
    private final HelicopterSeatEntity[] seats;
    private boolean syncModules;
    private UUID heliID;
    private float roll;
    private boolean engineRunning;
    private float enginePower;
    private MutableVec3 direction;
    private boolean modulesSynced;
    private float rotorRotation;

    public HelicopterBaseEntity(World worldIn, UUID id) {
        this(worldIn);
        this.prepareDefaultModules();
        this.setID(id);
    }

    public HelicopterBaseEntity(World worldIn) {
        super(worldIn);
        double w = 3.0;
        double h = 3.1f;
        double d = 8.0;
        this.setBox(0.0, 0.0, 0.0, w, h, d);
        this.seats = new HelicopterSeatEntity[3];
        for (int i = 0; i < this.seats.length; ++i) {
            float distance = i == 0 ? 1.5f : 0.0f;
            this.seats[i] = new HelicopterSeatEntity(distance, i, this);
            this.field_70170_p.func_72838_d((Entity)this.seats[i]);
        }
        this.setID(UUID.randomUUID());
        this.moduleSpots = new HelicopterModuleSpot[ModulePosition.values().length];
        this.moduleSpots[HelicopterBaseEntity.FRONT] = new HelicopterModuleSpot(ModulePosition.FRONT, this, 0.0f);
        this.moduleSpots[HelicopterBaseEntity.LEFT_SIDE] = new HelicopterModuleSpot(ModulePosition.LEFT_SIDE, this, (float)Math.PI);
        this.moduleSpots[HelicopterBaseEntity.RIGHT_SIDE] = new HelicopterModuleSpot(ModulePosition.RIGHT_SIDE, this, 0.0f);
        this.direction = new MutableVec3(0.0, 1.0, 0.0);
        this.syncModules = true;
    }

    private void setID(UUID id) {
        this.heliID = id;
        if (this.seats != null) {
            for (HelicopterSeatEntity seat : this.seats) {
                if (seat == null) continue;
                seat.setParentID(id);
            }
        }
    }

    public void prepareDefaultModules() {
        this.syncModules = false;
        this.getModuleSpot(ModulePosition.LEFT_SIDE).addModule(new HelicopterDoor());
        this.syncModules = true;
    }

    private void setBox(double offsetX, double offsetY, double offsetZ, double w, double h, double d) {
        double minX = this.func_174813_aQ().field_72340_a + offsetX;
        double minY = this.func_174813_aQ().field_72338_b + offsetY;
        double minZ = this.func_174813_aQ().field_72339_c + offsetZ;
        double maxX = this.func_174813_aQ().field_72340_a + w + offsetX;
        double maxY = this.func_174813_aQ().field_72338_b + h + offsetY;
        double maxZ = this.func_174813_aQ().field_72339_c + d + offsetZ;
        this.func_174826_a(new AxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ));
        this.field_70130_N = (float)(maxX - minX);
        this.field_70131_O = (float)(maxY - minY);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DATA_WATCHER_ENGINE_RUNNING, (Object)false);
    }

    public void func_70037_a(NBTTagCompound tagCompound) {
        super.func_70037_a(tagCompound);
        this.setID(UUID.fromString(tagCompound.func_74779_i("heliID")));
        NBTTagList spots = tagCompound.func_150295_c("spots", 10);
        for (int i = 0; i < spots.func_74745_c(); ++i) {
            NBTTagCompound spotData = spots.func_150305_b(i);
            ModulePosition position = ModulePosition.valueOf(spotData.func_74779_i("position").toUpperCase(Locale.ENGLISH));
            this.getModuleSpot(position).readFromNBT(spotData);
        }
        this.modulesSynced = false;
        System.out.println("read heliID=" + this.heliID);
    }

    public Iterable<ItemStack> func_184193_aE() {
        return null;
    }

    public ItemStack func_184582_a(EntityEquipmentSlot slot) {
        return null;
    }

    public void func_184201_a(EntityEquipmentSlot slot, ItemStack stack) {
    }

    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        tagCompound.func_74778_a("heliID", this.heliID.toString());
        NBTTagList spots = new NBTTagList();
        for (HelicopterModuleSpot spot : this.moduleSpots) {
            NBTTagCompound spotData = new NBTTagCompound();
            spot.writeToNBT(spotData);
            String position = spot.getPosition().name().toLowerCase(Locale.ENGLISH);
            spotData.func_74778_a("position", position);
            spots.func_74742_a((NBTBase)spotData);
        }
        tagCompound.func_74782_a("spots", (NBTBase)spots);
        System.out.println("wrote heliID=" + this.heliID);
    }

    public void func_70636_d() {
        if (!this.modulesSynced && this.func_70613_aW()) {
            for (HelicopterModuleSpot spot : this.moduleSpots) {
                JurassiCraft.NETWORK_WRAPPER.sendToAll((IMessage)new HelicopterModulesMessage(this.func_145782_y(), spot.getPosition(), spot));
            }
            this.modulesSynced = true;
        }
        super.func_70636_d();
        float time = this.enginePower / 80.0f;
        this.rotorRotation += Easings.easeInCubic(time, this.rotorRotation, this.enginePower, 1.0f);
        this.rotorRotation %= 360.0f;
        this.field_70143_R = 0.0f;
        this.field_70158_ak = true;
        for (HelicopterSeatEntity seat : this.seats) {
            if (seat == null) continue;
            seat.setParentID(this.heliID);
            seat.parent = this;
        }
        HelicopterSeatEntity seat = this.seats[0];
        if (seat != null) {
            boolean runEngine;
            Entity controller = seat.func_184179_bs();
            if (controller != null) {
                EntityPlayer rider = (EntityPlayer)controller;
                if (this.field_70170_p.field_72995_K) {
                    runEngine = this.handleClientRunning(rider);
                    if (this.isPilotThisClient(rider)) {
                        this.updateEngine(runEngine);
                        this.engineRunning = runEngine;
                        if (this.enginePower >= 40.0f) {
                            this.direction = this.drive(this.direction);
                        } else {
                            this.direction.set(0.0, 1.0, 0.0);
                        }
                    }
                }
            } else {
                runEngine = false;
                this.updateEngine(runEngine);
                this.direction.set(0.0, 1.0, 0.0);
            }
            this.field_70177_z = (float)((double)this.field_70177_z - this.direction.xCoord * 1.25);
            this.roll = (float)(this.direction.xCoord * 20.0);
            this.field_70125_A = (float)(-(this.direction.zCoord * 40.0));
            this.updateDirection(this.direction);
            if (this.engineRunning) {
                this.enginePower += 1.0f;
            } else {
                this.enginePower = this.enginePower >= 40.0f ? (this.enginePower -= 0.5f) : (this.enginePower -= 1.0f);
                if (this.enginePower < 0.0f) {
                    this.enginePower = 0.0f;
                }
            }
            if (this.enginePower >= 40.0f) {
                MutableVec3 localDir = new MutableVec3(this.direction.xCoord, this.direction.yCoord, this.direction.zCoord * 8.0);
                localDir = localDir.rotateYaw((float)Math.toRadians(-this.field_70177_z));
                float gravityCancellation = 0.08f;
                float speedY = 0.085f;
                double my = (double)0.085f * localDir.yCoord;
                if (my < (double)0.08f) {
                    my = 0.08f;
                }
                this.field_70181_x += my * 1.0 * (double)(this.enginePower / 80.0f);
                this.field_70159_w = localDir.xCoord / 10.0;
                this.field_70179_y = localDir.zCoord / 10.0;
            }
            if (this.enginePower >= 80.0f) {
                this.enginePower = 80.0f;
            }
        }
    }

    private void updateDirection(MutableVec3 direction) {
        if (this.field_70170_p.field_72995_K) {
            JurassiCraft.NETWORK_WRAPPER.sendToServer((IMessage)new HelicopterDirectionMessage(this.func_145782_y(), direction));
        } else {
            JurassiCraft.NETWORK_WRAPPER.sendToAll((IMessage)new HelicopterDirectionMessage(this.func_145782_y(), direction));
        }
    }

    @SideOnly(value=Side.CLIENT)
    private MutableVec3 drive(MutableVec3 direction) {
        if (Minecraft.func_71410_x().field_71474_y.field_74351_w.func_151470_d()) {
            direction.addVector(0.0, 0.0, 1.0);
        }
        if (Minecraft.func_71410_x().field_71474_y.field_74368_y.func_151470_d()) {
            direction.addVector(0.0, 0.0, -1.0);
        }
        if (Minecraft.func_71410_x().field_71474_y.field_74370_x.func_151470_d()) {
            direction.addVector(1.0, 0.0, 0.0);
        }
        if (Minecraft.func_71410_x().field_71474_y.field_74366_z.func_151470_d()) {
            direction.addVector(-1.0, 0.0, 0.0);
        }
        if (!Minecraft.func_71410_x().field_71474_y.field_74313_G.func_151470_d()) {
            direction.addVector(0.0, 1.0, 0.0);
        }
        return direction.normalize();
    }

    protected void func_85033_bc() {
    }

    public void updateEngine(boolean engineState) {
        if (this.field_70170_p.field_72995_K) {
            JurassiCraft.NETWORK_WRAPPER.sendToServer((IMessage)new HelicopterEngineMessage(this.func_145782_y(), engineState));
        } else {
            JurassiCraft.NETWORK_WRAPPER.sendToAll((IMessage)new HelicopterEngineMessage(this.func_145782_y(), engineState));
        }
    }

    @SideOnly(value=Side.CLIENT)
    private boolean isPilotThisClient(EntityPlayer pilot) {
        return pilot.func_110124_au().equals(Minecraft.func_71410_x().field_71439_g.func_110124_au());
    }

    @SideOnly(value=Side.CLIENT)
    private boolean handleClientRunning(EntityPlayer rider) {
        return this.isPilotThisClient(rider) && Minecraft.func_71410_x().field_71474_y.field_74314_A.func_151470_d();
    }

    public EnumActionResult func_184199_a(EntityPlayer player, Vec3d vec, ItemStack stack, EnumHand hand) {
        Vec3d localVec = vec.func_178785_b((float)Math.toRadians(this.field_70177_z));
        if (!this.attachModule(player, localVec, stack)) {
            System.out.println(localVec);
            if (localVec.field_72449_c > 0.6) {
                player.func_184220_m((Entity)this.seats[0]);
                return EnumActionResult.SUCCESS;
            }
            if (localVec.field_72449_c < 0.6 && localVec.field_72450_a > 0.0) {
                player.func_184220_m((Entity)this.seats[1]);
                return EnumActionResult.SUCCESS;
            }
            if (localVec.field_72449_c < 0.6 && localVec.field_72450_a < 0.0) {
                player.func_184220_m((Entity)this.seats[2]);
                return EnumActionResult.SUCCESS;
            }
            for (HelicopterModuleSpot spot : this.moduleSpots) {
                if (spot == null || !spot.isClicked(localVec)) continue;
                System.out.println(spot);
                spot.onClicked(player, vec);
                return EnumActionResult.SUCCESS;
            }
        }
        return EnumActionResult.PASS;
    }

    private boolean attachModule(EntityPlayer player, Vec3d localVec, ItemStack stack) {
        if (!this.field_70170_p.field_72995_K) {
            Item item;
            if (stack != null && (item = stack.func_77973_b()) instanceof HelicopterModuleItem) {
                HelicopterModuleItem moduleItem = (HelicopterModuleItem)item;
                HelicopterModule module = HelicopterModule.createFromID(moduleItem.getModuleID());
                for (HelicopterModuleSpot spot : this.moduleSpots) {
                    if (spot == null || !spot.isClicked(localVec) || !spot.addModule(module)) continue;
                    if (!player.field_71075_bZ.field_75098_d) {
                        --stack.field_77994_a;
                    }
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public AxisAlignedBB func_70114_g(Entity entityIn) {
        return this.getBoundingBox();
    }

    public AxisAlignedBB getBoundingBox() {
        return this.func_174813_aQ();
    }

    public boolean func_70104_M() {
        return false;
    }

    public EnumHandSide func_184591_cq() {
        return EnumHandSide.RIGHT;
    }

    public float getRoll() {
        return this.roll;
    }

    public void setRoll(float roll) {
        this.roll = roll;
    }

    public UUID getHeliID() {
        return this.heliID;
    }

    public void writeSpawnData(ByteBuf buffer) {
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.heliID.toString());
        for (HelicopterModuleSpot spot : this.moduleSpots) {
            spot.writeSpawnData(buffer);
        }
    }

    public void readSpawnData(ByteBuf additionalData) {
        this.setID(UUID.fromString(ByteBufUtils.readUTF8String((ByteBuf)additionalData)));
        for (HelicopterModuleSpot spot : this.moduleSpots) {
            spot.readSpawnData(additionalData);
        }
    }

    public boolean isEngineRunning() {
        return this.engineRunning;
    }

    public void setEngineRunning(boolean engineRunning) {
        this.engineRunning = engineRunning;
    }

    public float getEnginePower() {
        return this.enginePower;
    }

    public void setDirection(MutableVec3 direction) {
        this.direction.set(direction);
    }

    public HelicopterModuleSpot[] getModuleSpots() {
        return this.moduleSpots;
    }

    public HelicopterModuleSpot getModuleSpot(ModulePosition pos) {
        return this.moduleSpots[pos.ordinal()];
    }

    public boolean shouldSyncModules() {
        return this.syncModules;
    }

    public HelicopterSeatEntity getSeat(int index) {
        if (index < 0 || index >= this.seats.length) {
            throw new ArrayIndexOutOfBoundsException(index + ", size is " + this.seats.length);
        }
        return this.seats[index];
    }

    public void setSeat(int index, HelicopterSeatEntity seat) {
        this.seats[index] = seat;
    }

    public float getRotorRotation() {
        return this.rotorRotation;
    }
}

