/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.entity.vehicle.modules;

import io.netty.buffer.ByteBuf;
import java.util.List;
import javax.vecmathimpl.Matrix4d;
import javax.vecmathimpl.Vector3d;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jurassicraft.server.entity.vehicle.CarEntity;

public class SeatEntity
extends Entity
implements IEntityAdditionalSpawnData {
    private int id;
    private float offsetX;
    private float offsetY;
    private float offsetZ;
    private int parentId;
    private CarEntity parent;

    public SeatEntity(World world) {
        super(world);
    }

    public SeatEntity(World world, CarEntity parent, int id, float offsetX, float offsetY, float offsetZ, float width, float height) {
        super(world);
        this.func_70105_a(width, height + offsetY);
        this.id = id;
        this.offsetX = offsetX;
        this.offsetY = offsetY;
        this.offsetZ = offsetZ;
        this.updateParent(parent);
        this.updatePosition();
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.parent == null && !this.field_70170_p.field_72995_K) {
            this.func_70106_y();
            return;
        }
        if (this.parent != null) {
            this.updatePosition();
        }
        this.parent = null;
    }

    private void updatePosition() {
        Matrix4d matrix = new Matrix4d();
        matrix.setIdentity();
        Matrix4d transform = new Matrix4d();
        transform.setIdentity();
        transform.setTranslation(new Vector3d(this.parent.field_70165_t, this.parent.field_70163_u, this.parent.field_70161_v));
        matrix.mul(transform);
        transform.setIdentity();
        transform.rotY(Math.toRadians(180.0f - this.parent.field_70177_z));
        matrix.mul(transform);
        transform.setIdentity();
        transform.setTranslation(new Vector3d(this.offsetX, 0.0, this.offsetZ));
        matrix.mul(transform);
        this.func_70107_b(matrix.m03, matrix.m13, matrix.m23);
        this.field_70126_B = this.parent.field_70126_B;
        this.field_70177_z = this.parent.field_70177_z;
    }

    public Entity func_184179_bs() {
        List passengers = this.func_184188_bt();
        return passengers.size() > 0 ? (Entity)passengers.get(0) : null;
    }

    public boolean func_70067_L() {
        return true;
    }

    public void updateParent(CarEntity parent) {
        this.parent = parent;
        this.parentId = parent.func_145782_y();
    }

    public EnumActionResult func_184199_a(EntityPlayer player, Vec3d hitPosition, ItemStack stack, EnumHand hand) {
        if (this.func_184179_bs() == null) {
            player.func_184220_m((Entity)this);
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(NBTTagCompound compound) {
    }

    protected void func_70014_b(NBTTagCompound compound) {
    }

    public void func_184232_k(Entity passenger) {
        super.func_184232_k(passenger);
        if (this.func_184196_w(passenger)) {
            passenger.field_70177_z += this.field_70177_z - this.field_70126_B;
            this.applyPassengerRotation(passenger);
        }
    }

    protected void applyPassengerRotation(Entity passenger) {
        passenger.func_181013_g(this.field_70177_z);
        if (passenger instanceof EntityLivingBase) {
            ((EntityLivingBase)passenger).field_70760_ar = this.field_70126_B;
        }
        float deltaYaw = MathHelper.func_76142_g((float)(passenger.field_70177_z - this.field_70177_z));
        float clampedDeltaYaw = MathHelper.func_76131_a((float)deltaYaw, (float)-105.0f, (float)105.0f);
        passenger.field_70126_B += clampedDeltaYaw - deltaYaw;
        passenger.field_70177_z += clampedDeltaYaw - deltaYaw;
        passenger.func_70034_d(passenger.field_70177_z);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_184190_l(Entity entityToUpdate) {
        this.applyPassengerRotation(entityToUpdate);
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeByte(this.id);
        buffer.writeFloat(this.offsetX);
        buffer.writeFloat(this.offsetY);
        buffer.writeFloat(this.offsetZ);
        buffer.writeFloat(this.field_70130_N);
        buffer.writeFloat(this.field_70131_O);
        buffer.writeInt(this.parentId);
    }

    public void readSpawnData(ByteBuf buffer) {
        this.id = buffer.readByte();
        this.offsetX = buffer.readFloat();
        this.offsetY = buffer.readFloat();
        this.offsetZ = buffer.readFloat();
        this.func_70105_a(buffer.readFloat(), buffer.readFloat());
        Entity parent = this.field_70170_p.func_73045_a(buffer.readInt());
        if (parent instanceof CarEntity) {
            this.parent = (CarEntity)parent;
            this.parent.addSeat(this);
        }
    }

    public AxisAlignedBB func_70114_g(Entity entity) {
        return this.func_174813_aQ();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
    }

    public double func_70042_X() {
        return this.offsetY;
    }

    public int getId() {
        return this.id;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        CarEntity parent = this.parent;
        if (parent == null) {
            List cars = this.field_70170_p.func_72872_a(CarEntity.class, this.func_174813_aQ());
            for (CarEntity car : cars) {
                if (car.getSeat(this.getId()) != this) continue;
                parent = car;
                break;
            }
        }
        return parent != null && parent.func_70097_a(source, amount);
    }
}

