/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.item;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jurassicraft.server.block.ActionFigureBlock;
import org.jurassicraft.server.block.BlockHandler;
import org.jurassicraft.server.block.entity.ActionFigureBlockEntity;
import org.jurassicraft.server.dinosaur.Dinosaur;
import org.jurassicraft.server.entity.EntityHandler;
import org.jurassicraft.server.tab.TabHandler;
import org.jurassicraft.server.util.LangHelper;

public class ActionFigureItem
extends Item {
    public ActionFigureItem() {
        this.func_77637_a(TabHandler.DECORATIONS);
        this.func_77627_a(true);
    }

    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ActionFigureBlock block;
        if (player.func_175151_a(pos = pos.func_177972_a(side), side, stack) && (block = BlockHandler.ACTION_FIGURE).func_176196_c(world, pos)) {
            IBlockState state = block.func_176223_P();
            world.func_175656_a(pos, block.func_180642_a(world, pos, side, hitX, hitY, hitZ, 0, (EntityLivingBase)player));
            block.func_180633_a(world, pos, state, (EntityLivingBase)player, stack);
            int mode = this.getMode(stack);
            ActionFigureBlockEntity tile = (ActionFigureBlockEntity)world.func_175625_s(pos);
            if (tile != null) {
                tile.setDinosaur(stack.func_77952_i(), mode > 0 ? mode == 1 : world.field_73012_v.nextBoolean());
                if (!player.field_71075_bZ.field_75098_d) {
                    --stack.field_77994_a;
                }
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    public String func_77653_i(ItemStack stack) {
        String dinoName = this.getDinosaur(stack).getName().toLowerCase(Locale.ENGLISH).replaceAll(" ", "_");
        return new LangHelper("item.action_figure.name").withProperty("dino", "entity.jurassicraft." + dinoName + ".name").build();
    }

    public Dinosaur getDinosaur(ItemStack stack) {
        return EntityHandler.getDinosaurById(stack.func_77960_j());
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List<ItemStack> subtypes) {
        LinkedList<Dinosaur> dinosaurs = new LinkedList<Dinosaur>(EntityHandler.getDinosaurs().values());
        Collections.sort(dinosaurs);
        for (Dinosaur dinosaur : dinosaurs) {
            if (!dinosaur.shouldRegister()) continue;
            subtypes.add(new ItemStack(item, 1, EntityHandler.getDinosaurId(dinosaur)));
        }
    }

    public int getMode(ItemStack stack) {
        return this.getNBT(stack).func_74762_e("GenderMode");
    }

    public int changeMode(ItemStack stack) {
        NBTTagCompound nbt = this.getNBT(stack);
        int mode = this.getMode(stack) + 1;
        nbt.func_74768_a("GenderMode", mode %= 3);
        stack.func_77982_d(nbt);
        return mode;
    }

    public NBTTagCompound getNBT(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null) {
            nbt = new NBTTagCompound();
        }
        stack.func_77982_d(nbt);
        return nbt;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> lore, boolean advanced) {
        lore.add(TextFormatting.BLUE + I18n.func_135052_a((String)"lore.change_gender.name", (Object[])new Object[0]));
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        int mode = this.changeMode(stack);
        if (world.field_72995_K) {
            String modeString = "";
            if (mode == 0) {
                modeString = "random";
            } else if (mode == 1) {
                modeString = "male";
            } else if (mode == 2) {
                modeString = "female";
            }
            player.func_145747_a((ITextComponent)new TextComponentString(new LangHelper("actionfigure.genderchange.name").withProperty("mode", I18n.func_135052_a((String)("gender." + modeString + ".name"), (Object[])new Object[0])).build()));
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }
}

