/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.item;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jurassicraft.server.dinosaur.Dinosaur;
import org.jurassicraft.server.entity.EntityHandler;
import org.jurassicraft.server.tab.TabHandler;
import org.jurassicraft.server.util.LangHelper;

public class DinosaurSteakItem
extends ItemFood {
    public DinosaurSteakItem() {
        super(8, 0.8f, true);
        this.func_77627_a(true);
        this.func_77637_a(TabHandler.FOODS);
    }

    public String func_77653_i(ItemStack stack) {
        Dinosaur dinosaur = this.getDinosaur(stack);
        return new LangHelper("item.dinosaur_steak.name").withProperty("dino", "entity.jurassicraft." + dinosaur.getName().replace(" ", "_").toLowerCase(Locale.ENGLISH) + ".name").build();
    }

    public Dinosaur getDinosaur(ItemStack stack) {
        Dinosaur dinosaur = EntityHandler.getDinosaurById(stack.func_77952_i());
        if (dinosaur == null) {
            dinosaur = EntityHandler.VELOCIRAPTOR;
        }
        return dinosaur;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List<ItemStack> subtypes) {
        LinkedList<Dinosaur> dinosaurs = new LinkedList<Dinosaur>(EntityHandler.getDinosaurs().values());
        Collections.sort(dinosaurs);
        for (Dinosaur dinosaur : dinosaurs) {
            if (!dinosaur.shouldRegister()) continue;
            subtypes.add(new ItemStack(item, 1, EntityHandler.getDinosaurId(dinosaur)));
        }
    }
}

