/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.item;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jurassicraft.server.dinosaur.Dinosaur;
import org.jurassicraft.server.entity.DinosaurEntity;
import org.jurassicraft.server.entity.EntityHandler;
import org.jurassicraft.server.item.DNAContainerItem;
import org.jurassicraft.server.util.LangHelper;

public class HatchedEggItem
extends DNAContainerItem {
    public HatchedEggItem() {
        this.func_77627_a(true);
        this.func_77625_d(1);
    }

    public String func_77653_i(ItemStack stack) {
        String dinoName = this.getDinosaur(stack).getName().toLowerCase(Locale.ENGLISH).replaceAll(" ", "_");
        return new LangHelper("item.hatched_egg.name").withProperty("dino", "entity.jurassicraft." + dinoName + ".name").build();
    }

    public Dinosaur getDinosaur(ItemStack stack) {
        return EntityHandler.getDinosaurById(stack.func_77960_j());
    }

    public boolean getGender(EntityPlayer player, ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        boolean gender = player.field_70170_p.field_73012_v.nextBoolean();
        if (nbt == null) {
            nbt = new NBTTagCompound();
        }
        if (nbt.func_74764_b("Gender")) {
            gender = nbt.func_74767_n("Gender");
        } else {
            nbt.func_74757_a("Gender", gender);
        }
        stack.func_77982_d(nbt);
        return gender;
    }

    @Override
    public int getContainerId(ItemStack stack) {
        return EntityHandler.getDinosaurId(this.getDinosaur(stack));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List<ItemStack> subtypes) {
        LinkedList<Dinosaur> dinosaurs = new LinkedList<Dinosaur>(EntityHandler.getDinosaurs().values());
        Collections.sort(dinosaurs);
        for (Dinosaur dinosaur : dinosaurs) {
            if (!dinosaur.shouldRegister()) continue;
            subtypes.add(new ItemStack(item, 1, EntityHandler.getDinosaurId(dinosaur)));
        }
    }

    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        pos = pos.func_177972_a(side);
        if (side == EnumFacing.EAST || side == EnumFacing.WEST) {
            hitX = 1.0f - hitX;
        } else if (side == EnumFacing.NORTH || side == EnumFacing.SOUTH) {
            hitZ = 1.0f - hitZ;
        }
        if (player.func_175151_a(pos, side, stack)) {
            if (!world.field_72995_K) {
                Dinosaur dinosaur = this.getDinosaur(stack);
                try {
                    DinosaurEntity entity = dinosaur.getDinosaurClass().getDeclaredConstructor(World.class).newInstance(world);
                    entity.func_70107_b((float)pos.func_177958_n() + hitX, pos.func_177956_o(), (float)pos.func_177952_p() + hitZ);
                    entity.setAge(0);
                    entity.setGenetics(this.getGeneticCode(player, stack));
                    entity.setDNAQuality(this.getDNAQuality(player, stack));
                    entity.setMale(this.getGender(player, stack));
                    if (!player.func_70093_af()) {
                        entity.setOwner(player);
                    }
                    world.func_72838_d((Entity)entity);
                    if (!player.field_71075_bZ.field_75098_d) {
                        --stack.field_77994_a;
                    }
                }
                catch (ReflectiveOperationException e) {
                    e.printStackTrace();
                }
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }
}

