/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.item;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jurassicraft.server.api.SequencableItem;
import org.jurassicraft.server.genetics.PlantDNA;
import org.jurassicraft.server.item.ItemHandler;
import org.jurassicraft.server.plant.Plant;
import org.jurassicraft.server.plant.PlantHandler;
import org.jurassicraft.server.tab.TabHandler;
import org.jurassicraft.server.util.LangHelper;

public class PlantSoftTissueItem
extends Item
implements SequencableItem {
    public PlantSoftTissueItem() {
        this.func_77627_a(true);
        this.func_77637_a(TabHandler.PLANTS);
    }

    public String func_77653_i(ItemStack stack) {
        String plantName = this.getPlant(stack).getName().toLowerCase(Locale.ENGLISH).replaceAll(" ", "_");
        return new LangHelper("item.plant_soft_tissue.name").withProperty("plant", "plants." + plantName + ".name").build();
    }

    public Plant getPlant(ItemStack stack) {
        Plant plant = PlantHandler.getPlantById(stack.func_77952_i());
        if (plant == null) {
            plant = PlantHandler.SMALL_ROYAL_FERN;
        }
        return plant;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List<ItemStack> subtypes) {
        LinkedList<Plant> plants = new LinkedList<Plant>(PlantHandler.getPrehistoricPlants());
        HashMap<Plant, Integer> ids = new HashMap<Plant, Integer>();
        for (Plant plant : plants) {
            ids.put(plant, PlantHandler.getPlantId(plant));
        }
        Collections.sort(plants);
        for (Plant plant : plants) {
            subtypes.add(new ItemStack(item, 1, ((Integer)ids.get(plant)).intValue()));
        }
    }

    @Override
    public boolean isSequencable(ItemStack stack) {
        return true;
    }

    @Override
    public ItemStack getSequenceOutput(ItemStack stack, Random random) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null) {
            nbt = new NBTTagCompound();
            PlantDNA dna = new PlantDNA(stack.func_77952_i(), SequencableItem.randomQuality(random));
            dna.writeToNBT(nbt);
        }
        ItemStack output = new ItemStack((Item)ItemHandler.STORAGE_DISC, 1, stack.func_77952_i());
        output.func_77982_d(nbt);
        return output;
    }
}

