/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.server.message;

import io.netty.buffer.ByteBuf;
import net.ilexiconn.llibrary.server.network.AbstractMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import org.jurassicraft.server.entity.vehicle.HelicopterBaseEntity;
import org.jurassicraft.server.message.HelicopterMessages;

public class HelicopterEngineMessage
extends AbstractMessage<HelicopterEngineMessage> {
    private int heliID;
    private boolean engineState;

    public HelicopterEngineMessage() {
    }

    public HelicopterEngineMessage(int heliID, boolean engineState) {
        this.heliID = heliID;
        this.engineState = engineState;
    }

    public void onClientReceived(Minecraft minecraft, HelicopterEngineMessage message, EntityPlayer player, MessageContext messageContext) {
        HelicopterBaseEntity helicopter = HelicopterMessages.getHeli(player.field_70170_p, message.heliID);
        if (helicopter != null) {
            helicopter.setEngineRunning(message.engineState);
        }
    }

    public void onServerReceived(MinecraftServer minecraftServer, HelicopterEngineMessage message, EntityPlayer player, MessageContext messageContext) {
        HelicopterBaseEntity helicopter = HelicopterMessages.getHeli(player.field_70170_p, message.heliID);
        if (helicopter != null) {
            helicopter.setEngineRunning(message.engineState);
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.heliID = buf.readInt();
        this.engineState = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.heliID);
        buf.writeBoolean(this.engineState);
    }
}

