<!DOCTYPE html>
<html>
<html xmlns:wb="http://open.weibo.com/wb">
<head>
<title>
<?php
	/*
	 * Print the <title> tag based on what is being viewed.
	 */
	global $page, $paged;

	wp_title( '|', true, 'right' );

	// Add the blog name.
	bloginfo( 'name' );

	// Add a page number if necessary:
	if ( $paged >= 2 || $page >= 2 )
		echo ' | ' . sprintf( __( 'Page %s', 'CDC' ), max( $paged, $page ) );
	?>
</title>
<meta charset="utf-8" />
<meta name="viewport" content="width=device-width,initial-scale=1.0,user-scalable=no" />
<?php
$description = '';
$keywords = '';
 
if (is_home() || is_page()) {
   $description = "网站描述";
   $keywords = "网站关健词用逗号隔开";
}
elseif (is_single()) {
   $description1 = get_post_meta($post->ID, "description", true);
   $description = $description1 ? $description1 : $description2;
   
   $keywords = get_post_meta($post->ID, "keywords", true);
   if($keywords == '') {
      $tags = wp_get_post_tags($post->ID);    
      foreach ($tags as $tag ) {        
         $keywords = $keywords . $tag->name . ", ";    
      }
      $keywords = rtrim($keywords, ', ');
   }
}
elseif (is_category()) {
   // 分类的description可以到后台 - 文章 -分类目录，修改分类的描述
   $description = category_description();
   $keywords = single_cat_title('', false);
}
elseif (is_tag()){
   // 标签的description可以到后台 - 文章 - 标签，修改标签的描述
   $description = tag_description();
   $keywords = single_tag_title('', false);
}
$description = trim(strip_tags($description));
$keywords = trim(strip_tags($keywords));
?>
<meta name="description" content="<?php echo $description; ?>" />
<meta name="keywords" content="<?php echo $keywords; ?>" />
<link rel="shortcut icon" href="<?php bloginfo('template_directory'); ?>/images/favicon.ico" />
<link rel="stylesheet" href="<?php bloginfo('template_directory'); ?>/style.css" />
<link rel="stylesheet" href="<?php bloginfo('template_directory'); ?>/yzipi-pc.css" />
<link rel="stylesheet" href="<?php bloginfo('template_directory'); ?>/yzipi-ipad.css" />
<link rel="stylesheet" href="<?php bloginfo('template_directory'); ?>/yzipi-phone.css" />
<link rel="stylesheet" href="<?php bloginfo('template_directory'); ?>/yzipi-phone2.css" />
<script src="<?php bloginfo('template_directory'); ?>/js/html5shiv.js"></script>
<script src="<?php bloginfo('template_directory'); ?>/js/css3-mediaqueries.js"></script>
<script src="<?php bloginfo('template_directory'); ?>/js/selectivizr-min.js"></script>
<script src="<?php bloginfo('template_directory'); ?>/js/jquery.1.11.1.js" type="text/javascript"></script>
<script src="<?php bloginfo('template_directory'); ?>/js/main.js" type="text/javascript"></script>
<script src="http://tjs.sjs.sinajs.cn/open/api/js/wb.js" type="text/javascript" charset="utf-8"></script>
<?php wp_head(); ?>
</head>
<body>
<header id="header-web">
  <div class="header-main">
    <hgroup class="logo">
      <h1><a href="<?php echo esc_url( home_url( '/' ) ); ?>" title="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>" rel="home"><img src="<?php bloginfo('template_directory'); ?>/images/logo.png" alt="<?php bloginfo( 'name' ); ?>"></a></h1>
      <h3>
        <?php bloginfo( 'description' ); ?>
      </h3>
    </hgroup>
    <!--logo-->
    <nav class="header-nav">
      <?php wp_nav_menu( array( 'theme_location'=>'top-menu','container' => '') ); ?>
    </nav>
    <!--header-nav-->
    <div class="weibo">
    <a href="<?php echo esc_url( home_url( '/' ) ); ?>contribute" target="_blank">稿</a>
    </div>
    <!--header-main--> 
  </div>
</header>
<!--header-web-->
<div id="main">
<div id="soutab">
  <form method="get" class="search" action="<?php echo esc_url( home_url( '/' ) ); ?>" >
    <input class="text" type="text" name="s" placeholder="搜索一下">
    <input class="button" value="搜索" type="submit">
  </form>
</div>