window.mraid = ( function() {
    function mraid() {
        this.evListeners = {};

    }
    mraid.prototype.addEventListener = function(ev, cb) {
        if(!this.evListeners.hasOwnProperty(ev)) {
            this.evListeners[ev] = [];
        }
        this.evListeners[ev].push(cb);
    }
	mraid.prototype.removeEventListener = function(ev, cb) {
		if(this.evListeners.hasOwnProperty(ev)) {
			if(typeof cb == 'undefined') {
				this.evListeners[ev] = [];
			} else {
				for(var i  = 0; i < this.evListeners[ev].length; i++) {
					if(this.evListeners[ev][i] == cb) {
						this.evListeners[ev].splice(i, 1);
					}
				}
			}
		}
	}

	mraid.prototype.supports = function(feature) {
    	return mraidHostBridge.supports(feature);
    }

	mraid.prototype.expand = function(cb) {
		mraidHostBridge.expand();
	}
	mraid.prototype.getScreenSize = function() {
		return JSON.parse(mraidHostBridge.getScreenSize());
	}

	mraid.prototype.getCurrentPosition = function() {
    	return JSON.parse(mraidHostBridge.getCurrentPosition());
    }

	mraid.prototype.getDefaultPosition = function() {
        return JSON.parse(mraidHostBridge.getDefaultPosition());
    }

	// return ResizeProperties
	mraid.prototype.getResizeProperties = function() {
		return JSON.parse(mraidHostBridge.getResizeProperties());
	}
	mraid.prototype.setResizeProperties = function(props) {
		mraidHostBridge.setResizeProperties(props);
	}

    mraid.prototype.fallback = function() {
        mraidHostBridge.fallback();
    }
	mraid.prototype.getVersion = function() {
	    return mraidHostBridge.getVersion();
	}
	mraid.prototype.isViewable = function() {
	    return mraidHostBridge.isViewable();
	}
	mraid.prototype.open = function(url) {
	    mraidHostBridge.open(url);
	}
	mraid.prototype.playVideo = function(url) {
	    mraidHostBridge.playVideo(url);
	}
	mraid.prototype.resize = function() {
	    mraidHostBridge.resize();
	}
	mraid.prototype.setExpandProperties = function(props) {
		mraidHostBridge.setExpandProperties(JSON.stringify(props));
	}
	mraid.prototype.getExpandProperties = function() {
		return JSON.parse(mraidHostBridge.getExpandProperties());
	}
	mraid.prototype.getMaxSize = function() {
		return JSON.parse(mraidHostBridge.getMaxSize());
	}
	mraid.prototype.getPlacementType = function() {
		return mraidHostBridge.getPlacementType();
	}
	mraid.prototype.getState = function() {
		return mraidHostBridge.getState();
	}
    mraid.prototype.close = function() {
		mraidHostBridge.close();
	}

	mraid.prototype.unload = function() {
    	mraidHostBridge.unload();
    }

    mraid.prototype.getCurrentAppOrientation = function() {
       	return JSON.parse(mraidHostBridge.getCurrentAppOrientation());
    }

	mraid.prototype.setOrientationProperties = function(props) {
        mraidHostBridge.setOrientationProperties(JSON.stringify(props));
    }

    mraid.prototype.getOrientationProperties = function() {
        return JSON.parse(mraidHostBridge.getOrientationProperties());
    }

	return new mraid();
})();

window.mraidController = ( function() {
	function mraidController() {

	}
	mraidController.prototype.triggerEvent = function(ev, params) {
		if (mraid.evListeners.hasOwnProperty(ev)) {
			for (var i = 0; i < mraid.evListeners[ev].length; i++) {
				mraid.evListeners[ev][i].apply(null, params)
			}
		}
	}

	return new mraidController();
})();